/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc50.agent.jaas;

import java.lang.reflect.Field;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.JAASRealm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.tc50.agent.jaas.CatalinaSSOUser;

public class CatalinaJAASRealm
extends JAASRealm {
    private static Log log = LogFactory.getLog(CatalinaJAASRealm.class);
    private boolean requiresRoleMap = false;

    public void init() {
        super.init();
        try {
            if (this.getRoleMapField() != null) {
                this.requiresRoleMap = true;
                log.debug((Object)"Realm requires role mapping (Tomcat 5.0.30 ? )");
            } else {
                log.debug((Object)"Realm does note requires role mapping (Tomcat 5.0.28 ? )");
                this.requiresRoleMap = false;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Initializing CatalinaJAASRealm : " + e.getMessage()), (Throwable)e);
        }
    }

    protected Principal createPrincipal(String username, Subject subject) {
        CatalinaSSOUser p = CatalinaSSOUser.newInstance((Realm)this, subject);
        if (this.requiresRoleMap) {
            try {
                ArrayList<Principal> roles = new ArrayList<Principal>();
                for (Principal principal : subject.getPrincipals()) {
                    String principalClass = principal.getClass().getName();
                    if (this.getRoleClassNames().contains(principalClass)) {
                        log.debug((Object)("Adding role : " + principal.getName()));
                        roles.add(principal);
                    }
                    if (!(principal instanceof Group) || !"Roles".equals(principal.getName())) continue;
                    Group grp = (Group)principal;
                    Enumeration en = grp.members();
                    while (en.hasMoreElements()) {
                        Principal roleP = (Principal)en.nextElement();
                        log.debug((Object)("Adding role : " + roleP.getName()));
                        roles.add(roleP);
                    }
                }
                log.debug((Object)"Storing roles in parent roleMap");
                Map m = (Map)this.getRoleMapField().get((Object)this);
                m.put(p, roles);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                return p;
            }
        }
        return p;
    }

    protected Field getRoleMapField() {
        Field[] fields;
        for (Field field : fields = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredFields()) {
            log.debug((Object)("Field:" + field.getName()));
            if (!field.getName().equals("roleMap")) continue;
            return field;
        }
        return null;
    }
}

