/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc50.agent;

import java.lang.reflect.Field;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgentRequest;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.tc50.agent.jaas.CatalinaSSOUser;

public class CatalinaNativeRealm
extends RealmBase {
    private static Log log = LogFactory.getLog(CatalinaNativeRealm.class);
    protected static final String name = "CatalinaNativeRealm";
    private boolean requiresRoleMap = false;
    private static List _roleClasses = new ArrayList();

    public void init() {
        super.init();
        try {
            if (this.getRoleMapField() != null) {
                this.requiresRoleMap = true;
                log.debug((Object)"Realm requires role mapping (Tomcat 5.0.30 ? )");
            } else {
                log.debug((Object)"Realm does note requires role mapping (Tomcat 5.0.28 ? )");
                this.requiresRoleMap = false;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Initializing CatalinaJAASRealm : " + e.getMessage()), (Throwable)e);
        }
    }

    public Principal authenticate(String username, String credentials) {
        try {
            SSOIdentityManagerService im = Lookup.getInstance().lookupSSOAgent().getSSOIdentityManager();
            String requester = "";
            SSOAgentRequest request = (SSOAgentRequest)AbstractSSOAgent._currentRequest.get();
            if (request != null) {
                requester = request.getRequester();
            } else {
                log.warn((Object)"No SSO Agent request found in thread local variable, can't identify requester");
            }
            SSOUser ssoUser = im.findUserInSession(requester, username);
            Principal principal = null;
            if (ssoUser != null) {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)ssoUser);
                SSORole[] ssoRolePrincipals = im.findRolesBySSOSessionId(requester, username);
                for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                    subject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                }
                principal = this.createPrincipal(username, subject);
            }
            return principal;
        }
        catch (SSOIdentityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Session authentication failed : " + username), (Throwable)e);
            throw new RuntimeException("Fatal error authenticating session : " + e);
        }
    }

    protected Principal createPrincipal(String username, Subject subject) {
        CatalinaSSOUser p = CatalinaSSOUser.newInstance((Realm)this, subject);
        if (this.requiresRoleMap) {
            try {
                ArrayList<Principal> roles = new ArrayList<Principal>();
                for (Principal principal : subject.getPrincipals()) {
                    String principalClass = principal.getClass().getName();
                    if (_roleClasses.contains(principalClass)) {
                        log.debug((Object)("Adding role : " + principal.getName()));
                        roles.add(principal);
                    }
                    if (!(principal instanceof Group) || !"Roles".equals(principal.getName())) continue;
                    Group grp = (Group)principal;
                    Enumeration en = grp.members();
                    while (en.hasMoreElements()) {
                        Principal roleP = (Principal)en.nextElement();
                        log.debug((Object)("Adding role : " + roleP.getName()));
                        roles.add(roleP);
                    }
                }
                log.debug((Object)"Storing roles in parent roleMap");
                Map m = (Map)this.getRoleMapField().get((Object)this);
                m.put(p, roles);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                return p;
            }
        }
        return p;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return this.authenticate(username, username);
    }

    protected Field getRoleMapField() {
        Field[] fields;
        for (Field field : fields = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredFields()) {
            log.debug((Object)("Field:" + field.getName()));
            if (!field.getName().equals("roleMap")) continue;
            return field;
        }
        return null;
    }

    static {
        _roleClasses.add("org.josso.gateway.identity.service.BaseRoleImpl");
    }
}

