/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc55.gateway.reverseproxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.josso.agent.Lookup;
import org.josso.agent.reverseproxy.ProxyContextConfig;
import org.josso.agent.reverseproxy.ReverseProxyConfiguration;

public class ReverseProxyValve
extends ValveBase
implements Lifecycle {
    static final String METHOD_GET = "GET";
    static final String METHOD_POST = "POST";
    static final String METHOD_PUT = "PUT";
    private final String METHOD_HEAD = "HEAD";
    private String _configurationFileName;
    private ReverseProxyConfiguration _rpc;
    private boolean started;
    private String _reverseProxyHost;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private static final String info = "org.josso.tc55.gateway.reverseproxy.ReverseProxyValve/1.0";

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("ReverseProxy already started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this._rpc = Lookup.getInstance().lookupReverseProxyConfiguration();
        }
        catch (Exception e) {
            throw new LifecycleException(e.getMessage(), (Throwable)e);
        }
        this.log("Started");
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("ReverseProxy not started");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.log("Stopped");
    }

    public void setConfiguration(String configurationFileName) {
        this._configurationFileName = configurationFileName;
    }

    public String getConfiguration() {
        return this._configurationFileName;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        GetMethod method;
        int uriTrailStartPos;
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)"ReverseProxyValve Acting.");
        }
        ProxyContextConfig[] contexts = this._rpc.getProxyContexts();
        HttpClient client = new HttpClient();
        HttpServletRequest hsr = request.getRequest();
        String uri = hsr.getRequestURI();
        String uriContext = null;
        StringTokenizer st = new StringTokenizer(uri.substring(1), "/");
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            uriContext = "/" + token;
        }
        if (uriContext == null) {
            uriContext = uri;
        }
        String proxyForwardHost = null;
        String proxyForwardUri = null;
        for (int i = 0; i < contexts.length; ++i) {
            if (!contexts[i].getContext().equals(uriContext)) continue;
            this.log("Proxy context mapped to host/uri: " + contexts[i].getForwardHost() + contexts[i].getForwardUri());
            proxyForwardHost = contexts[i].getForwardHost();
            proxyForwardUri = contexts[i].getForwardUri();
            break;
        }
        if (proxyForwardHost == null) {
            this.log("URI '" + uri + "' can't be mapped to host");
            this.getNext().invoke(request, response);
            return;
        }
        if (proxyForwardUri == null) {
            uriTrailStartPos = uri.substring(1).indexOf("/") + 1;
            proxyForwardUri = uri.substring(uriTrailStartPos);
        } else {
            uriTrailStartPos = uri.substring(1).indexOf("/") + 1;
            proxyForwardUri = proxyForwardUri + uri.substring(uriTrailStartPos);
        }
        if (hsr.getMethod().equals(METHOD_GET)) {
            GetMethod getMethod;
            method = getMethod = new GetMethod(proxyForwardHost + proxyForwardUri + (hsr.getQueryString() != null ? "?" + hsr.getQueryString() : ""));
        } else if (hsr.getMethod().equals(METHOD_POST)) {
            PostMethod postMethod = new PostMethod(proxyForwardHost + proxyForwardUri + (hsr.getQueryString() != null ? "?" + hsr.getQueryString() : ""));
            postMethod.setRequestBody((InputStream)hsr.getInputStream());
            method = postMethod;
        } else if (hsr.getMethod().equals("HEAD")) {
            HeadMethod headMethod = new HeadMethod(proxyForwardHost + proxyForwardUri + (hsr.getQueryString() != null ? "?" + hsr.getQueryString() : ""));
            method = headMethod;
        } else if (hsr.getMethod().equals(METHOD_PUT)) {
            method = new PutMethod(proxyForwardHost + proxyForwardUri + (hsr.getQueryString() != null ? "?" + hsr.getQueryString() : ""));
        } else {
            throw new UnsupportedOperationException("Unknown method : " + hsr.getMethod());
        }
        Enumeration hne = hsr.getHeaderNames();
        while (hne.hasMoreElements()) {
            String hn = (String)hne.nextElement();
            if (hn.equalsIgnoreCase("host")) {
                method.addRequestHeader("Host", proxyForwardHost);
                continue;
            }
            Enumeration hvals = hsr.getHeaders(hn);
            while (hvals.hasMoreElements()) {
                String hv = (String)hvals.nextElement();
                method.addRequestHeader(hn, hv);
            }
        }
        String reverseProxyHost = this.getReverseProxyHost(request);
        method.addRequestHeader("Josso-ReversE-Proxy", reverseProxyHost);
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)("Sending Josso-ReversE-Proxy " + reverseProxyHost));
        }
        method.setFollowRedirects(false);
        client.getParams().setVersion(new HttpVersion(1, 0));
        int statusCode = -1;
        try {
            statusCode = client.executeMethod((HttpMethod)method);
        }
        catch (HttpRecoverableException e) {
            this.log("A recoverable exception occurred " + e.getMessage());
        }
        catch (IOException e) {
            this.log("Failed to connect.");
            e.printStackTrace();
        }
        if (statusCode == -1) {
            this.log("Failed to recover from exception.");
        }
        byte[] responseBody = method.getResponseBody();
        method.releaseConnection();
        HttpServletResponse sres = response.getResponse();
        sres.setStatus(method.getStatusCode());
        Header[] responseHeaders = method.getResponseHeaders();
        for (int i = 0; i < responseHeaders.length; ++i) {
            Header responseHeader = responseHeaders[i];
            String name = responseHeader.getName();
            String value = responseHeader.getValue();
            switch (method.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (!"Location".equalsIgnoreCase(name) && !"Content-Location".equalsIgnoreCase(name) && !"URI".equalsIgnoreCase(name) || value.indexOf(proxyForwardHost) < 0) break;
                    String trail = value.substring(proxyForwardHost.length());
                    value = this.getReverseProxyHost(request) + trail;
                    if (!this.container.getLogger().isDebugEnabled()) break;
                    this.container.getLogger().debug((Object)("Adjusting redirect header to " + value));
                }
            }
            sres.addHeader(name, value);
        }
        if (responseBody != null && responseBody.length > 0) {
            sres.getOutputStream().write(responseBody);
        }
        sres.getOutputStream().flush();
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)"ReverseProxyValve finished.");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ReverseProxyValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getReverseProxyHost(Request request) {
        HttpServletRequest hsr = request.getRequest();
        if (this._reverseProxyHost == null) {
            ReverseProxyValve reverseProxyValve = this;
            synchronized (reverseProxyValve) {
                String h;
                this._reverseProxyHost = h = hsr.getProtocol().substring(0, hsr.getProtocol().indexOf("/")).toLowerCase() + "://" + hsr.getServerName() + (hsr.getServerPort() != 80 ? ":" + hsr.getServerPort() : "");
            }
        }
        return this._reverseProxyHost;
    }

    protected void log(String message) {
        if (this.container != null) {
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)(this.toString() + ": " + message));
            }
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.container != null) {
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)(this.toString() + ": " + message), throwable);
            }
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

