/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc70.agent.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSOUser;

public class CatalinaSSOUser
extends GenericPrincipal
implements SSOUser {
    private static Log logger = LogFactory.getLog(CatalinaSSOUser.class);
    private static List _userClasses = new ArrayList();
    private static List _roleClasses = new ArrayList();
    private SSOUser _ssoUser;

    public static CatalinaSSOUser newInstance(Realm realm, Subject subject) {
        String password = null;
        ArrayList<String> roles = new ArrayList<String>();
        SSOUser ssoUser = null;
        String username = null;
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof CatalinaSSOUser) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found old CatalinaSSOUser Principal " + principal));
                }
                return (CatalinaSSOUser)((Object)principal);
            }
            String principalClass = principal.getClass().getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Principal: " + principalClass + " " + principal));
            }
            if (_userClasses.contains(principalClass)) {
                username = principal.getName();
            }
            if (_roleClasses.contains(principalClass)) {
                roles.add(principal.getName());
            }
            if (principal instanceof Group && "Roles".equals(principal.getName())) {
                Group grp = (Group)principal;
                Enumeration en = grp.members();
                while (en.hasMoreElements()) {
                    Principal roleP = (Principal)en.nextElement();
                    roles.add(roleP.getName());
                }
            }
            if (!(principal instanceof SSOUser)) continue;
            ssoUser = (SSOUser)principal;
        }
        if (ssoUser == null) {
            logger.error((Object)"Fatal: Subject does not contain an SSOUser Principal");
            return null;
        }
        if (username != null) {
            return new CatalinaSSOUser(ssoUser, realm, username, password, roles);
        }
        return null;
    }

    private CatalinaSSOUser(SSOUser ssoUser, Realm realm, String name, String password) {
        this(ssoUser, realm, name, password, null);
    }

    private CatalinaSSOUser(SSOUser ssoUser, Realm realm, String name, String password, List roles) {
        super(name, password, roles);
        this._ssoUser = ssoUser;
    }

    public String getSessionId() {
        return null;
    }

    public SSONameValuePair[] getProperties() {
        return this._ssoUser.getProperties();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CatalinaSSOUser[");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }

    static {
        _userClasses.add("org.josso.gateway.identity.service.BaseUserImpl");
        _roleClasses.add("org.josso.gateway.identity.service.BaseRoleImpl");
    }
}

