/*
 * Decompiled with CFR 0.152.
 */
package org.josso.wls10.agent;

import java.security.Principal;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.http.HttpSSOAgent;
import org.josso.gateway.identity.SSOUser;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;
import weblogic.servlet.security.ServletAuthentication;

public class WLSSSOAgent
extends HttpSSOAgent {
    private static final String JOSSO_LOGIN_URI = "/josso-wls/josso_login.jsp";
    private static final String JOSSO_USER_LOGIN_URI = "/josso-wls/josso_user_login.jsp";
    private static final String JOSSO_SECURITY_CHECK_URI = "/josso-wls/josso_security_check.jsp";
    private static final String JOSSO_LOGOUT_URI = "/josso-wls/josso_logout.jsp";
    private static final String JOSSO_AUTHENTICATION_URI = "/josso-wls/josso_authentication.jsp";
    private static Log logger = LogFactory.getLog(WLSSSOAgent.class);

    public String buildLoginUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String onErrorUrl = this.getGatewayLoginErrorUrl();
        String backto = this.buildBackToURL(hreq, JOSSO_SECURITY_CHECK_URI);
        loginUrl = loginUrl + "?josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    protected boolean isAuthenticationAlwaysRequired() {
        return true;
    }

    protected Principal authenticate(SSOAgentRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Authenticating SSO Agent request ... ");
        }
        try {
            GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
            String ssoSessionId = r.getSessionId();
            int result = ServletAuthentication.login((String)ssoSessionId, (String)ssoSessionId, (HttpServletRequest)r.getRequest(), (HttpServletResponse)r.getResponse());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticating SSO Agent request : " + result));
            }
            if (result == 0) {
                SSOUser p = this.getSSOIdentityManager().findUserInSession(request.getRequester(), ssoSessionId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("WLS Principal is " + p.getName()));
                }
                return p;
            }
        }
        catch (LoginException e) {
            logger.warn((Object)e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, (Throwable)e);
            }
            return null;
        }
        return null;
    }

    public String getJOSSOLoginUri() {
        return JOSSO_LOGIN_URI;
    }

    public String getJOSSOUserLoginUri() {
        return JOSSO_USER_LOGIN_URI;
    }

    public String getJOSSOSecurityCheckUri() {
        return JOSSO_SECURITY_CHECK_URI;
    }

    public String getJOSSOLogoutUri() {
        return JOSSO_LOGOUT_URI;
    }

    public String getJOSSOAuthenticationUri() {
        return JOSSO_AUTHENTICATION_URI;
    }

    protected void log(String message) {
        logger.info((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        logger.info((Object)message, throwable);
    }
}

