/*
 * Decompiled with CFR 0.152.
 */
package org.josso.wls10.agent.jaas;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.service.BaseRole;
import weblogic.security.principal.WLSAbstractPrincipal;

public class WLSJOSSORole
extends WLSAbstractPrincipal
implements BaseRole {
    private SSORole ssoRole;
    private HashMap members = new HashMap(5);

    public WLSJOSSORole(SSORole role) {
        this();
        this.ssoRole = role;
        this.setName(role.getName());
    }

    public WLSJOSSORole() {
    }

    public boolean addMember(Principal user) {
        boolean isMember = this.members.containsKey(user);
        if (!isMember) {
            this.members.put(user, user);
        }
        return !isMember;
    }

    public boolean isMember(Principal member) {
        boolean isMember = this.members.containsKey(member);
        if (!isMember) {
            Collection values = this.members.values();
            Iterator iter = values.iterator();
            while (!isMember && iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof BaseRole)) continue;
                BaseRole role = (BaseRole)next;
                isMember = role.isMember(member);
            }
        }
        return isMember;
    }

    public Enumeration members() {
        return Collections.enumeration(this.members.values());
    }

    public boolean removeMember(Principal user) {
        Object prev = this.members.remove(user);
        return prev != null;
    }

    public String getName() {
        return this.ssoRole.getName();
    }

    public void setName(String name) {
        if (this.ssoRole instanceof BaseRole) {
            ((BaseRole)this.ssoRole).setName(name);
        }
        super.setName(name);
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        Iterator iter = this.members.keySet().iterator();
        while (iter.hasNext()) {
            tmp.append(iter.next());
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }
}

