/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.web.bind.RequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import sample.contact.AddPermission;
import sample.contact.Contact;
import sample.contact.ContactManager;

public class AddPermissionController
extends SimpleFormController
implements InitializingBean {
    private ContactManager contactManager;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.contactManager, (String)"A ContactManager implementation is required");
    }

    protected ModelAndView disallowDuplicateFormSubmission(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BindException errors = new BindException(this.formBackingObject(request), this.getCommandName());
        errors.reject("err.duplicateFormSubmission", "Duplicate form submission. *");
        return this.showForm(request, response, errors);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        int contactId = RequestUtils.getRequiredIntParameter((HttpServletRequest)request, (String)"contactId");
        Contact contact = this.contactManager.getById(new Long(contactId));
        AddPermission addPermission = new AddPermission();
        addPermission.setContact(contact);
        return addPermission;
    }

    protected ModelAndView handleInvalidSubmit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.disallowDuplicateFormSubmission(request, response);
    }

    private Map listPermissions(HttpServletRequest request) {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(new Integer(BasePermission.ADMINISTRATION.getMask()), this.getApplicationContext().getMessage("select.administer", null, "Administer", request.getLocale()));
        map.put(new Integer(BasePermission.READ.getMask()), this.getApplicationContext().getMessage("select.read", null, "Read", request.getLocale()));
        map.put(new Integer(BasePermission.DELETE.getMask()), this.getApplicationContext().getMessage("select.delete", null, "Delete", request.getLocale()));
        return map;
    }

    private Map listRecipients(HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", this.getApplicationContext().getMessage("select.pleaseSelect", null, "-- please select --", request.getLocale()));
        for (String recipient : this.contactManager.getAllRecipients()) {
            map.put(recipient, recipient);
        }
        return map;
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        AddPermission addPermission = (AddPermission)command;
        PrincipalSid sid = new PrincipalSid(addPermission.getRecipient());
        Permission permission = BasePermission.buildFromMask((int)addPermission.getPermission());
        try {
            this.contactManager.addPermission(addPermission.getContact(), (Sid)sid, permission);
        }
        catch (DataAccessException existingPermission) {
            existingPermission.printStackTrace();
            errors.rejectValue("recipient", "err.recipientExistsForContact", "Addition failure.");
            return this.showForm(request, response, errors);
        }
        return new ModelAndView((View)new RedirectView(this.getSuccessView()));
    }

    protected Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Map> model = new HashMap<String, Map>();
        model.put("recipients", this.listRecipients(request));
        model.put("permissions", this.listPermissions(request));
        return model;
    }

    public void setContactManager(ContactManager contact) {
        this.contactManager = contact;
    }
}

