/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.io.Serializable;
import java.util.Random;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.acls.MutableAcl;
import org.springframework.security.acls.MutableAclService;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityImpl;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import sample.contact.Contact;

public class DataSourcePopulator
implements InitializingBean {
    JdbcTemplate template;
    private MutableAclService mutableAclService;
    Random rnd = new Random();
    TransactionTemplate tt;
    String[] firstNames = new String[]{"Bob", "Mary", "James", "Jane", "Kristy", "Kirsty", "Kate", "Jeni", "Angela", "Melanie", "Kent", "William", "Geoff", "Jeff", "Adrian", "Amanda", "Lisa", "Elizabeth", "Prue", "Richard", "Darin", "Phillip", "Michael", "Belinda", "Samantha", "Brian", "Greg", "Matthew"};
    String[] lastNames = new String[]{"Smith", "Williams", "Jackson", "Rictor", "Nelson", "Fitzgerald", "McAlpine", "Sutherland", "Abbott", "Hall", "Edwards", "Gates", "Black", "Brown", "Gray", "Marwell", "Booch", "Johnson", "McTaggart", "Parklin", "Findlay", "Robinson", "Giugni", "Lang", "Chi", "Carmichael"};
    private int createEntities = 50;

    public void afterPropertiesSet() throws Exception {
        int i;
        Assert.notNull((Object)this.mutableAclService, (String)"mutableAclService required");
        Assert.notNull((Object)this.template, (String)"dataSource required");
        Assert.notNull((Object)this.tt, (String)"platformTransactionManager required");
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_IGNORED")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
        this.template.execute("CREATE TABLE ACL_SID(ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 100) NOT NULL PRIMARY KEY,PRINCIPAL BOOLEAN NOT NULL,SID VARCHAR_IGNORECASE(100) NOT NULL,CONSTRAINT UNIQUE_UK_1 UNIQUE(SID,PRINCIPAL));");
        this.template.execute("CREATE TABLE ACL_CLASS(ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 100) NOT NULL PRIMARY KEY,CLASS VARCHAR_IGNORECASE(100) NOT NULL,CONSTRAINT UNIQUE_UK_2 UNIQUE(CLASS));");
        this.template.execute("CREATE TABLE ACL_OBJECT_IDENTITY(ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 100) NOT NULL PRIMARY KEY,OBJECT_ID_CLASS BIGINT NOT NULL,OBJECT_ID_IDENTITY BIGINT NOT NULL,PARENT_OBJECT BIGINT,OWNER_SID BIGINT,ENTRIES_INHERITING BOOLEAN NOT NULL,CONSTRAINT UNIQUE_UK_3 UNIQUE(OBJECT_ID_CLASS,OBJECT_ID_IDENTITY),CONSTRAINT FOREIGN_FK_1 FOREIGN KEY(PARENT_OBJECT)REFERENCES ACL_OBJECT_IDENTITY(ID),CONSTRAINT FOREIGN_FK_2 FOREIGN KEY(OBJECT_ID_CLASS)REFERENCES ACL_CLASS(ID),CONSTRAINT FOREIGN_FK_3 FOREIGN KEY(OWNER_SID)REFERENCES ACL_SID(ID));");
        this.template.execute("CREATE TABLE ACL_ENTRY(ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 100) NOT NULL PRIMARY KEY,ACL_OBJECT_IDENTITY BIGINT NOT NULL,ACE_ORDER INT NOT NULL,SID BIGINT NOT NULL,MASK INTEGER NOT NULL,GRANTING BOOLEAN NOT NULL,AUDIT_SUCCESS BOOLEAN NOT NULL,AUDIT_FAILURE BOOLEAN NOT NULL,CONSTRAINT UNIQUE_UK_4 UNIQUE(ACL_OBJECT_IDENTITY,ACE_ORDER),CONSTRAINT FOREIGN_FK_4 FOREIGN KEY(ACL_OBJECT_IDENTITY) REFERENCES ACL_OBJECT_IDENTITY(ID),CONSTRAINT FOREIGN_FK_5 FOREIGN KEY(SID) REFERENCES ACL_SID(ID));");
        this.template.execute("CREATE TABLE USERS(USERNAME VARCHAR_IGNORECASE(50) NOT NULL PRIMARY KEY,PASSWORD VARCHAR_IGNORECASE(50) NOT NULL,ENABLED BOOLEAN NOT NULL);");
        this.template.execute("CREATE TABLE AUTHORITIES(USERNAME VARCHAR_IGNORECASE(50) NOT NULL,AUTHORITY VARCHAR_IGNORECASE(50) NOT NULL,CONSTRAINT FK_AUTHORITIES_USERS FOREIGN KEY(USERNAME) REFERENCES USERS(USERNAME));");
        this.template.execute("CREATE UNIQUE INDEX IX_AUTH_USERNAME ON AUTHORITIES(USERNAME,AUTHORITY);");
        this.template.execute("CREATE TABLE CONTACTS(ID BIGINT NOT NULL PRIMARY KEY, CONTACT_NAME VARCHAR_IGNORECASE(50) NOT NULL, EMAIL VARCHAR_IGNORECASE(50) NOT NULL)");
        this.template.execute("INSERT INTO USERS VALUES('rod','a564de63c2d0da68cf47586ee05984d7',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('dianne','65d15fe9156f9c4bbffd98085992a44e',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('scott','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('peter','22b5c9accc6e1ba628cedc63a72d57f8',FALSE);");
        this.template.execute("INSERT INTO USERS VALUES('bill','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('bob','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('jane','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('rod','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('rod','ROLE_SUPERVISOR');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('dianne','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('scott','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('peter','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('bill','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('bob','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('jane','ROLE_USER');");
        this.template.execute("INSERT INTO contacts VALUES (1, 'John Smith', 'john@somewhere.com');");
        this.template.execute("INSERT INTO contacts VALUES (2, 'Michael Citizen', 'michael@xyz.com');");
        this.template.execute("INSERT INTO contacts VALUES (3, 'Joe Bloggs', 'joe@demo.com');");
        this.template.execute("INSERT INTO contacts VALUES (4, 'Karen Sutherland', 'karen@sutherland.com');");
        this.template.execute("INSERT INTO contacts VALUES (5, 'Mitchell Howard', 'mitchell@abcdef.com');");
        this.template.execute("INSERT INTO contacts VALUES (6, 'Rose Costas', 'rose@xyz.com');");
        this.template.execute("INSERT INTO contacts VALUES (7, 'Amanda Smith', 'amanda@abcdef.com');");
        this.template.execute("INSERT INTO contacts VALUES (8, 'Cindy Smith', 'cindy@smith.com');");
        this.template.execute("INSERT INTO contacts VALUES (9, 'Jonathan Citizen', 'jonathan@xyz.com');");
        for (i = 10; i < this.createEntities; ++i) {
            String[] person = this.selectPerson();
            this.template.execute("INSERT INTO contacts VALUES (" + i + ", '" + person[2] + "', '" + person[0].toLowerCase() + "@" + person[1].toLowerCase() + ".com');");
        }
        for (i = 1; i < this.createEntities; ++i) {
            ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(Contact.class, (Serializable)new Long(i));
            this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.grantPermissions(1, "rod", BasePermission.ADMINISTRATION);
        this.grantPermissions(2, "rod", BasePermission.READ);
        this.grantPermissions(3, "rod", BasePermission.READ);
        this.grantPermissions(3, "rod", BasePermission.WRITE);
        this.grantPermissions(3, "rod", BasePermission.DELETE);
        this.grantPermissions(4, "rod", BasePermission.ADMINISTRATION);
        this.grantPermissions(4, "dianne", BasePermission.ADMINISTRATION);
        this.grantPermissions(4, "scott", BasePermission.READ);
        this.grantPermissions(5, "dianne", BasePermission.ADMINISTRATION);
        this.grantPermissions(5, "dianne", BasePermission.READ);
        this.grantPermissions(6, "dianne", BasePermission.READ);
        this.grantPermissions(6, "dianne", BasePermission.WRITE);
        this.grantPermissions(6, "dianne", BasePermission.DELETE);
        this.grantPermissions(6, "scott", BasePermission.READ);
        this.grantPermissions(7, "scott", BasePermission.ADMINISTRATION);
        this.grantPermissions(8, "dianne", BasePermission.ADMINISTRATION);
        this.grantPermissions(8, "dianne", BasePermission.READ);
        this.grantPermissions(8, "scott", BasePermission.READ);
        this.grantPermissions(9, "scott", BasePermission.ADMINISTRATION);
        this.grantPermissions(9, "scott", BasePermission.READ);
        this.grantPermissions(9, "scott", BasePermission.WRITE);
        this.grantPermissions(9, "scott", BasePermission.DELETE);
        this.changeOwner(5, "dianne");
        this.changeOwner(6, "dianne");
        this.changeOwner(7, "scott");
        this.changeOwner(8, "dianne");
        this.changeOwner(9, "scott");
        String[] users = new String[]{"bill", "bob", "jane"};
        Permission[] permissions = new Permission[]{BasePermission.ADMINISTRATION, BasePermission.READ, BasePermission.DELETE};
        for (int i2 = 10; i2 < this.createEntities; ++i2) {
            String user = users[this.rnd.nextInt(users.length)];
            Permission permission = permissions[this.rnd.nextInt(permissions.length)];
            this.grantPermissions(i2, user, permission);
            String user2 = users[this.rnd.nextInt(users.length)];
            Permission permission2 = permissions[this.rnd.nextInt(permissions.length)];
            this.grantPermissions(i2, user2, permission2);
        }
        SecurityContextHolder.clearContext();
    }

    private void changeOwner(int contactNumber, String newOwnerUsername) {
        AclImpl acl = (AclImpl)this.mutableAclService.readAclById((ObjectIdentity)new ObjectIdentityImpl(Contact.class, (Serializable)new Long(contactNumber)));
        acl.setOwner((Sid)new PrincipalSid(newOwnerUsername));
        this.updateAclInTransaction((MutableAcl)acl);
    }

    public int getCreateEntities() {
        return this.createEntities;
    }

    private void grantPermissions(int contactNumber, String recipientUsername, Permission permission) {
        AclImpl acl = (AclImpl)this.mutableAclService.readAclById((ObjectIdentity)new ObjectIdentityImpl(Contact.class, (Serializable)new Long(contactNumber)));
        acl.insertAce(acl.getEntries().length, permission, (Sid)new PrincipalSid(recipientUsername), true);
        this.updateAclInTransaction((MutableAcl)acl);
    }

    private String[] selectPerson() {
        String firstName = this.firstNames[this.rnd.nextInt(this.firstNames.length)];
        String lastName = this.lastNames[this.rnd.nextInt(this.lastNames.length)];
        return new String[]{firstName, lastName, firstName + " " + lastName};
    }

    public void setCreateEntities(int createEntities) {
        this.createEntities = createEntities;
    }

    public void setDataSource(DataSource dataSource) {
        this.template = new JdbcTemplate(dataSource);
    }

    public void setMutableAclService(MutableAclService mutableAclService) {
        this.mutableAclService = mutableAclService;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.tt = new TransactionTemplate(platformTransactionManager);
    }

    private void updateAclInTransaction(MutableAcl acl) {
        this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ MutableAclService access$000(DataSourcePopulator x0) {
        return x0.mutableAclService;
    }
}

