/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="VerificationField", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="VerificationField")
@JsonPropertyOrder(value={"field", "column", "precision", "zeroThreshold", "extensions"})
public class VerificationField
extends PMMLObject
implements HasExtensions<VerificationField>,
HasFieldReference<VerificationField>,
Indexable<String> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private String field;
    @XmlAttribute(name="column")
    @JsonProperty(value="column")
    private String column;
    @XmlAttribute(name="precision")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="precision")
    private Number precision;
    @XmlAttribute(name="zeroThreshold")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="zeroThreshold")
    private Number zeroThreshold;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final Number DEFAULT_PRECISION = new RealNumberAdapter().unmarshal("1E-6");
    private static final Number DEFAULT_ZERO_THRESHOLD = new RealNumberAdapter().unmarshal("1E-16");
    private static final long serialVersionUID = 67371272L;

    public VerificationField() {
    }

    @ValueConstructor
    public VerificationField(@Property(value="field") String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public VerificationField(Field<?> field) {
        this(field != null ? field.requireName() : null);
    }

    @Override
    public String getKey() {
        return this.requireField();
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.VERIFICATIONFIELD_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public VerificationField setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public VerificationField setColumn(@Property(value="column") String column) {
        this.column = column;
        return this;
    }

    public Number getPrecision() {
        if (this.precision == null) {
            return DEFAULT_PRECISION;
        }
        return this.precision;
    }

    public VerificationField setPrecision(@Property(value="precision") Number precision) {
        this.precision = precision;
        return this;
    }

    public Number getZeroThreshold() {
        if (this.zeroThreshold == null) {
            return DEFAULT_ZERO_THRESHOLD;
        }
        return this.zeroThreshold;
    }

    public VerificationField setZeroThreshold(@Property(value="zeroThreshold") Number zeroThreshold) {
        this.zeroThreshold = zeroThreshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VerificationField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

