/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.time_series.ARIMA;
import org.dmg.pmml.time_series.ExponentialSmoothing;
import org.dmg.pmml.time_series.GARCH;
import org.dmg.pmml.time_series.PMMLAttributes;
import org.dmg.pmml.time_series.PMMLElements;
import org.dmg.pmml.time_series.SeasonalTrendDecomposition;
import org.dmg.pmml.time_series.SpectralAnalysis;
import org.dmg.pmml.time_series.StateSpaceModel;
import org.dmg.pmml.time_series.TimeSeries;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="TimeSeriesModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "timeSeries", "spectralAnalysis", "arima", "exponentialSmoothing", "seasonalTrendDecomposition", "stateSpaceModel", "garch", "modelVerification"})
@JsonRootName(value="TimeSeriesModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "bestFit", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "timeSeries", "spectralAnalysis", "arima", "exponentialSmoothing", "seasonalTrendDecomposition", "stateSpaceModel", "garch", "modelVerification"})
@Added(value=Version.PMML_4_0)
public class TimeSeriesModel
extends Model
implements HasExtensions<TimeSeriesModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="bestFit", required=true)
    @JsonProperty(value="bestFit")
    private Algorithm bestFit;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    @Added(value=Version.PMML_4_1, removable=true)
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.3.7")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    @Added(value=Version.PMML_4_1, removable=true)
    private ModelExplanation modelExplanation;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="TimeSeries", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TimeSeries")
    @CollectionElementType(value=TimeSeries.class)
    private List<TimeSeries> timeSeries;
    @XmlElement(name="SpectralAnalysis", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="SpectralAnalysis")
    private SpectralAnalysis spectralAnalysis;
    @XmlElement(name="ARIMA", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ARIMA")
    private ARIMA arima;
    @XmlElement(name="ExponentialSmoothing", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ExponentialSmoothing")
    private ExponentialSmoothing exponentialSmoothing;
    @XmlElement(name="SeasonalTrendDecomposition", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="SeasonalTrendDecomposition")
    private SeasonalTrendDecomposition seasonalTrendDecomposition;
    @XmlElement(name="StateSpaceModel", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="StateSpaceModel")
    @Added(value=Version.PMML_4_4)
    private StateSpaceModel stateSpaceModel;
    @XmlElement(name="GARCH", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="GARCH")
    @Added(value=Version.PMML_4_4)
    private GARCH garch;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371272L;

    public TimeSeriesModel() {
    }

    @ValueConstructor
    public TimeSeriesModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="bestFit") Algorithm bestFit, @Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.bestFit = bestFit;
        this.miningSchema = miningSchema;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public TimeSeriesModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TIMESERIESMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public TimeSeriesModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public TimeSeriesModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Algorithm requireBestFit() {
        if (this.bestFit == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TIMESERIESMODEL_BESTFIT);
        }
        return this.bestFit;
    }

    public Algorithm getBestFit() {
        return this.bestFit;
    }

    public TimeSeriesModel setBestFit(@Property(value="bestFit") Algorithm bestFit) {
        this.bestFit = bestFit;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public TimeSeriesModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public TimeSeriesModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TimeSeriesModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public TimeSeriesModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public TimeSeriesModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public TimeSeriesModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public TimeSeriesModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public TimeSeriesModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasTimeSeries() {
        return this.timeSeries != null && !this.timeSeries.isEmpty();
    }

    public List<TimeSeries> getTimeSeries() {
        if (this.timeSeries == null) {
            this.timeSeries = new ArrayList<TimeSeries>();
        }
        return this.timeSeries;
    }

    public TimeSeriesModel addTimeSeries(TimeSeries ... timeSeries) {
        this.getTimeSeries().addAll(Arrays.asList(timeSeries));
        return this;
    }

    public SpectralAnalysis requireSpectralAnalysis() {
        if (this.spectralAnalysis == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_SPECTRALANALYSIS);
        }
        return this.spectralAnalysis;
    }

    public SpectralAnalysis getSpectralAnalysis() {
        return this.spectralAnalysis;
    }

    public TimeSeriesModel setSpectralAnalysis(@Property(value="spectralAnalysis") SpectralAnalysis spectralAnalysis) {
        this.spectralAnalysis = spectralAnalysis;
        return this;
    }

    public ARIMA requireARIMA() {
        if (this.arima == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_ARIMA);
        }
        return this.arima;
    }

    public ARIMA getARIMA() {
        return this.arima;
    }

    public TimeSeriesModel setARIMA(@Property(value="arima") ARIMA arima) {
        this.arima = arima;
        return this;
    }

    public ExponentialSmoothing requireExponentialSmoothing() {
        if (this.exponentialSmoothing == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_EXPONENTIALSMOOTHING);
        }
        return this.exponentialSmoothing;
    }

    public ExponentialSmoothing getExponentialSmoothing() {
        return this.exponentialSmoothing;
    }

    public TimeSeriesModel setExponentialSmoothing(@Property(value="exponentialSmoothing") ExponentialSmoothing exponentialSmoothing) {
        this.exponentialSmoothing = exponentialSmoothing;
        return this;
    }

    public SeasonalTrendDecomposition requireSeasonalTrendDecomposition() {
        if (this.seasonalTrendDecomposition == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_SEASONALTRENDDECOMPOSITION);
        }
        return this.seasonalTrendDecomposition;
    }

    public SeasonalTrendDecomposition getSeasonalTrendDecomposition() {
        return this.seasonalTrendDecomposition;
    }

    public TimeSeriesModel setSeasonalTrendDecomposition(@Property(value="seasonalTrendDecomposition") SeasonalTrendDecomposition seasonalTrendDecomposition) {
        this.seasonalTrendDecomposition = seasonalTrendDecomposition;
        return this;
    }

    public StateSpaceModel requireStateSpaceModel() {
        if (this.stateSpaceModel == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_STATESPACEMODEL);
        }
        return this.stateSpaceModel;
    }

    public StateSpaceModel getStateSpaceModel() {
        return this.stateSpaceModel;
    }

    public TimeSeriesModel setStateSpaceModel(@Property(value="stateSpaceModel") StateSpaceModel stateSpaceModel) {
        this.stateSpaceModel = stateSpaceModel;
        return this;
    }

    public GARCH requireGARCH() {
        if (this.garch == null) {
            throw new MissingElementException(this, PMMLElements.TIMESERIESMODEL_GARCH);
        }
        return this.garch;
    }

    public GARCH getGARCH() {
        return this.garch;
    }

    public TimeSeriesModel setGARCH(@Property(value="garch") GARCH garch) {
        this.garch = garch;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public TimeSeriesModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasTimeSeries()) {
                status = PMMLObject.traverse(visitor, this.getTimeSeries());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getSpectralAnalysis(), this.getARIMA(), this.getExponentialSmoothing(), this.getSeasonalTrendDecomposition(), this.getStateSpaceModel(), this.getGARCH(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Algorithm implements StringValue<Algorithm>
    {
        ARIMA("ARIMA"),
        EXPONENTIAL_SMOOTHING("ExponentialSmoothing"),
        SEASONAL_TREND_DECOMPOSITION("SeasonalTrendDecomposition"),
        SPECTRAL_ANALYSIS("SpectralAnalysis"),
        STATE_SPACE_MODEL("StateSpaceModel"),
        GARCH("GARCH");

        private final String value;

        private Algorithm(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Algorithm fromValue(String v) {
            for (Algorithm c : Algorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

