/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Enumeration;
import java.util.regex.Pattern;
import jnr.constants.Constant;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.AddressInfo;
import jnr.constants.platform.Errno;
import jnr.constants.platform.INAddr;
import jnr.constants.platform.IP;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Shutdown;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketMessage;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import jnr.netdb.Protocol;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.Ifaddr;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static final Pattern ALREADY_BOUND_PATTERN = Pattern.compile("[Aa]lready.*bound");
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    protected AddressFamily soDomain;
    protected ProtocolFamily soProtocolFamily;
    protected Sock soType;
    protected Protocol soProtocol = Protocol.getProtocolByNumber((int)0);
    private static final String JRUBY_SERVER_SOCKET_ERROR = "use ServerSocket for servers (https://github.com/jruby/jruby/wiki/ServerSocket)";

    static void createSocket(Ruby runtime2) {
        RubyClass rb_cSocket = runtime2.defineClass("Socket", runtime2.getClass("BasicSocket"), RubySocket::new);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        runtime2.loadConstantSet(rb_mConstants, Sock.class);
        runtime2.loadConstantSet(rb_mConstants, SocketOption.class);
        runtime2.loadConstantSet(rb_mConstants, SocketLevel.class);
        runtime2.loadConstantSet(rb_mConstants, ProtocolFamily.class);
        runtime2.loadConstantSet(rb_mConstants, AddressFamily.class);
        runtime2.loadConstantSet(rb_mConstants, INAddr.class);
        runtime2.loadConstantSet(rb_mConstants, IPProto.class);
        runtime2.loadConstantSet(rb_mConstants, Shutdown.class);
        runtime2.loadConstantSet(rb_mConstants, TCP.class);
        runtime2.loadConstantSet(rb_mConstants, NameInfo.class);
        runtime2.loadConstantSet(rb_mConstants, SocketMessage.class);
        rb_mConstants.setConstant("SOMAXCONN", RubyFixnum.newFixnum(runtime2, 128L));
        rb_mConstants.setConstant("IPPORT_RESERVED", RubyFixnum.newFixnum(runtime2, 1024L));
        rb_mConstants.setConstant("IPPORT_USERRESERVED", RubyFixnum.newFixnum(runtime2, 5000L));
        rb_mConstants.setConstant("AI_PASSIVE", runtime2.newFixnum((Constant)AddressInfo.AI_PASSIVE));
        rb_mConstants.setConstant("AI_CANONNAME", runtime2.newFixnum((Constant)AddressInfo.AI_CANONNAME));
        rb_mConstants.setConstant("AI_NUMERICHOST", runtime2.newFixnum((Constant)AddressInfo.AI_NUMERICHOST));
        rb_mConstants.setConstant("AI_ALL", runtime2.newFixnum((Constant)AddressInfo.AI_ALL));
        rb_mConstants.setConstant("AI_V4MAPPED_CFG", runtime2.newFixnum((Constant)AddressInfo.AI_V4MAPPED_CFG));
        rb_mConstants.setConstant("AI_ADDRCONFIG", runtime2.newFixnum((Constant)AddressInfo.AI_ADDRCONFIG));
        rb_mConstants.setConstant("AI_V4MAPPED", runtime2.newFixnum((Constant)AddressInfo.AI_V4MAPPED));
        rb_mConstants.setConstant("AI_NUMERICSERV", runtime2.newFixnum((Constant)AddressInfo.AI_NUMERICSERV));
        rb_mConstants.setConstant("AI_DEFAULT", runtime2.newFixnum((Constant)AddressInfo.AI_DEFAULT));
        rb_mConstants.setConstant("AI_MASK", runtime2.newFixnum((Constant)AddressInfo.AI_MASK));
        rb_mConstants.setConstant("IP_MULTICAST_TTL", runtime2.newFixnum(IP.IP_MULTICAST_TTL.value()));
        rb_mConstants.setConstant("IP_MULTICAST_LOOP", runtime2.newFixnum(IP.IP_MULTICAST_LOOP.value()));
        rb_mConstants.setConstant("IP_ADD_MEMBERSHIP", runtime2.newFixnum(IP.IP_ADD_MEMBERSHIP.value()));
        rb_mConstants.setConstant("IP_MAX_MEMBERSHIPS", runtime2.newFixnum(IP.IP_MAX_MEMBERSHIPS.value()));
        rb_mConstants.setConstant("IP_DEFAULT_MULTICAST_LOOP", runtime2.newFixnum((Constant)IP.IP_DEFAULT_MULTICAST_LOOP));
        rb_mConstants.setConstant("IP_DEFAULT_MULTICAST_TTL", runtime2.newFixnum((Constant)IP.IP_DEFAULT_MULTICAST_TTL));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject _fd) {
        Ruby runtime2 = context.runtime;
        if (_fd instanceof RubyFixnum) {
            int intFD = (int)((RubyFixnum)_fd).getLongValue();
            ChannelFD fd = runtime2.getFilenoUtil().getWrapperFromFileno(intFD);
            if (fd == null) {
                throw runtime2.newErrnoEBADFError();
            }
            RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate();
            socket2.initFieldsFromDescriptor(runtime2, fd);
            socket2.initSocket(fd);
            return socket2;
        }
        throw runtime2.newTypeError(_fd, context.runtime.getFixnum());
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2) {
        Ruby runtime2 = context.runtime;
        this.initFromArgs(runtime2, domain, type2);
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        Ruby runtime2 = context.runtime;
        this.initFromArgs(runtime2, domain, type2, protocol2);
        return this;
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2) {
        return this.connect_nonblock(context, arg2, context.nil);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2, IRubyObject opts) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        return this.doConnectNonblock(context, addr2, RubySocket.extractExceptionArg(context, opts));
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject arg2) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        return this.doConnect(context, addr2, true);
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject arg2) {
        SocketAddress sockaddr;
        if (arg2 instanceof Addrinfo) {
            Addrinfo addr2 = (Addrinfo)arg2;
            sockaddr = addr2.getSocketAddress();
        } else {
            sockaddr = Sockaddr.addressFromSockaddr(context, arg2);
        }
        this.doBind(context, sockaddr);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        return RubyUDPSocket.recvfrom(this, context, _length);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject[] args2) {
        if (this.getOpenFile() == null) {
            throw context.runtime.newErrnoENOTCONNError("socket is not connected");
        }
        return RubyUDPSocket.recvfrom_nonblock(this, context, args2);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject accept(ThreadContext context) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true, optional=1)
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        return SocketUtils.gethostname(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getifaddrs(ThreadContext context, IRubyObject recv2) {
        RubyArray list2 = RubyArray.newArray(context.runtime);
        RubyClass Ifaddr2 = (RubyClass)context.runtime.getClassFromPath("Socket::Ifaddr");
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                list2.append(new Ifaddr(context.runtime, Ifaddr2, iface));
                for (InterfaceAddress iaddr : iface.getInterfaceAddresses()) {
                    list2.append(new Ifaddr(context.runtime, Ifaddr2, iface, iaddr));
                }
            }
        }
        catch (RuntimeException | SocketException ex) {
            if (ex instanceof RaiseException) {
                throw (RaiseException)ex;
            }
            throw SocketUtils.sockerr_with_trace(context.runtime, "getifaddrs: " + ex.toString(), ex.getStackTrace());
        }
        return list2;
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.gethostbyaddr(context, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getservbyname(context, args2);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return Sockaddr.pack_sockaddr_in(context, port, host);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_in(context, addr2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String path2 = filename2.convertToString().asJavaString();
        return Sockaddr.pack_sockaddr_un(context, path2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_un(context, addr2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        return SocketUtils.gethostbyname(context, hostname);
    }

    @JRubyMethod(required=2, optional=5, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getaddrinfo(context, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getnameinfo(context, args2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ip_address_list(ThreadContext context, IRubyObject self2) {
        return SocketUtils.ip_address_list(context);
    }

    @JRubyMethod(name={"socketpair", "pair"}, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        ProtocolFamily pf = SocketUtils.protocolFamilyFromArg(protocol2);
        if (pf == null) {
            pf = ProtocolFamily.PF_UNIX;
        }
        if (pf != ProtocolFamily.PF_UNIX && pf.ordinal() != 0) {
            throw context.runtime.newErrnoEOPNOTSUPPError("Socket.socketpair only supports streaming UNIX sockets");
        }
        return RubySocket.socketpair(context, recv2, domain, type2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject domain, IRubyObject type2) {
        Sock s2;
        AddressFamily af = SocketUtils.addressFamilyFromArg(domain);
        if (af == null) {
            af = AddressFamily.AF_UNIX;
        }
        if ((s2 = SocketUtils.sockFromArg(type2)) == null) {
            s2 = Sock.SOCK_STREAM;
        }
        if (af != AddressFamily.AF_UNIX || s2 != Sock.SOCK_STREAM) {
            throw context.runtime.newErrnoEOPNOTSUPPError("Socket.socketpair only supports streaming UNIX sockets");
        }
        Ruby runtime2 = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyClass socketClass = runtime2.getClass("Socket");
            RubySocket sock0 = new RubySocket(runtime2, socketClass);
            ChannelFD fd0 = RubySocket.newChannelFD(runtime2, (Channel)sp[0]);
            sock0.initFieldsFromDescriptor(runtime2, fd0);
            sock0.initSocket(fd0);
            RubySocket sock1 = new RubySocket(runtime2, socketClass);
            ChannelFD fd1 = RubySocket.newChannelFD(runtime2, (Channel)sp[1]);
            sock1.initFieldsFromDescriptor(runtime2, fd1);
            sock1.initSocket(fd1);
            return runtime2.newArray((IRubyObject)sock0, (IRubyObject)sock1);
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private void initFieldsFromDescriptor(Ruby runtime2, ChannelFD fd) {
        Channel mainChannel = fd.ch;
        if (mainChannel instanceof SocketChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocolFamily = ProtocolFamily.PF_INET;
            this.soProtocol = Protocol.getProtocolByName((String)"tcp");
        } else if (mainChannel instanceof UnixSocketChannel) {
            this.soDomain = AddressFamily.AF_UNIX;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocolFamily = ProtocolFamily.PF_UNIX;
        } else if (mainChannel instanceof DatagramChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_DGRAM;
            this.soProtocolFamily = ProtocolFamily.PF_INET;
        } else {
            throw runtime2.newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
        }
    }

    private void initFromArgs(Ruby runtime2, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        this.setProtocol(protocol2);
        this.initFromArgs(runtime2, domain, type2);
    }

    private void initFromArgs(Ruby runtime2, IRubyObject domain, IRubyObject type2) {
        this.setDomain(runtime2, domain);
        this.setType(runtime2, type2);
        ChannelFD fd = this.initChannelFD(runtime2);
        this.initSocket(fd);
    }

    protected void initFromServer(Ruby runtime2, RubySocket serverSocket, SocketChannel socketChannel) {
        this.soDomain = serverSocket.soDomain;
        this.soType = serverSocket.soType;
        this.soProtocol = serverSocket.soProtocol;
        this.initSocket(RubySocket.newChannelFD(runtime2, socketChannel));
    }

    protected ChannelFD initChannelFD(Ruby runtime2) {
        try {
            AbstractSelectableChannel channel;
            switch (this.soType) {
                case SOCK_STREAM: {
                    if (this.soProtocolFamily == ProtocolFamily.PF_UNIX || this.soProtocolFamily == ProtocolFamily.PF_LOCAL) {
                        channel = UnixSocketChannel.open();
                        break;
                    }
                    if (this.soProtocolFamily == ProtocolFamily.PF_INET || this.soProtocolFamily == ProtocolFamily.PF_INET6 || this.soProtocolFamily == ProtocolFamily.PF_UNSPEC) {
                        channel = SocketChannel.open();
                        break;
                    }
                    throw runtime2.newArgumentError("unsupported protocol family `" + this.soProtocolFamily + "'");
                }
                case SOCK_DGRAM: {
                    channel = DatagramChannel.open();
                    break;
                }
                default: {
                    throw runtime2.newArgumentError("unsupported socket type `" + this.soType + "'");
                }
            }
            return RubySocket.newChannelFD(runtime2, channel);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(runtime2, "initialize: " + e.toString(), e);
        }
    }

    private void setProtocol(IRubyObject protocol2) {
        this.soProtocol = SocketUtils.protocolFromArg(protocol2);
    }

    private void setType(Ruby runtime2, IRubyObject type2) {
        Sock sockType = SocketUtils.sockFromArg(type2);
        if (sockType == null) {
            throw SocketUtils.sockerr(runtime2, "unknown socket type " + type2);
        }
        this.soType = sockType;
    }

    private void setDomain(Ruby runtime2, IRubyObject domain) {
        AddressFamily family2 = SocketUtils.addressFamilyFromArg(domain);
        if (family2 == null) {
            throw SocketUtils.sockerr(runtime2, "unknown socket domain " + domain);
        }
        this.soDomain = family2;
        String name2 = this.soDomain.name();
        if (name2.startsWith("pseudo_")) {
            name2 = name2.substring(7);
        }
        this.soProtocolFamily = ProtocolFamily.valueOf((String)("PF" + name2.substring(2)));
    }

    private IRubyObject doConnectNonblock(ThreadContext context, SocketAddress addr2, boolean ex) {
        Ruby runtime2 = context.runtime;
        Channel channel = this.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            throw runtime2.newErrnoENOPROTOOPTError();
        }
        boolean result2 = this.tryConnect(context, runtime2, channel, addr2, ex, false);
        if (!result2) {
            if (!ex) {
                return runtime2.newSymbol("wait_writable");
            }
            throw runtime2.newErrnoEINPROGRESSWritableError();
        }
        return runtime2.newFixnum(0);
    }

    protected IRubyObject doConnect(ThreadContext context, SocketAddress addr2, boolean ex) {
        Ruby runtime2 = context.runtime;
        Channel channel = this.getChannel();
        this.tryConnect(context, runtime2, channel, addr2, ex, true);
        return runtime2.newFixnum(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryConnect(ThreadContext context, Ruby runtime2, Channel channel, SocketAddress addr2, boolean ex, boolean blocking) {
        SelectableChannel selectable = (SelectableChannel)channel;
        try {
            Object object = selectable.blockingLock();
            synchronized (object) {
                boolean oldBlocking = selectable.isBlocking();
                try {
                    selectable.configureBlocking(false);
                    block14: while (true) {
                        boolean result2 = true;
                        if (channel instanceof SocketChannel) {
                            SocketChannel socket2 = (SocketChannel)channel;
                            result2 = socket2.isConnectionPending() ? socket2.finishConnect() : socket2.connect(addr2);
                        } else if (channel instanceof UnixSocketChannel) {
                            result2 = ((UnixSocketChannel)channel).connect((UnixSocketAddress)addr2);
                        } else {
                            if (!(channel instanceof DatagramChannel)) {
                                throw runtime2.newErrnoENOPROTOOPTError();
                            }
                            ((DatagramChannel)channel).connect(addr2);
                        }
                        if (!blocking || result2) {
                            boolean bl = result2;
                            return bl;
                        }
                        while (true) {
                            if (context.getThread().select(channel, this, 8)) continue block14;
                            context.blockingThreadPoll();
                        }
                        break;
                    }
                }
                finally {
                    selectable.configureBlocking(oldBlocking);
                }
            }
        }
        catch (ClosedChannelException e) {
            throw context.runtime.newErrnoECONNREFUSEDError();
        }
        catch (AlreadyConnectedException e) {
            if (!ex) {
                return false;
            }
            throw runtime2.newErrnoEISCONNError();
        }
        catch (ConnectionPendingException e) {
            throw runtime2.newErrnoEINPROGRESSWritableError();
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "connect(2): unknown host");
        }
        catch (SocketException e) {
            this.getOpenFile().cleanup(runtime2, true);
            throw RubySocket.buildSocketException(runtime2, e, "connect(2)", addr2);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(runtime2, "connect(2): name or service not known", e);
        }
        catch (IllegalArgumentException e) {
            throw RubySocket.sockerr(runtime2, e.getMessage(), e);
        }
    }

    protected void doBind(ThreadContext context, SocketAddress iaddr) {
        block7: {
            Ruby runtime2 = context.runtime;
            Channel channel = this.getChannel();
            try {
                if (channel instanceof SocketChannel) {
                    Socket socket2 = ((SocketChannel)channel).socket();
                    socket2.bind(iaddr);
                    break block7;
                }
                if (channel instanceof UnixSocketChannel) break block7;
                if (channel instanceof DatagramChannel) {
                    DatagramSocket socket3 = ((DatagramChannel)channel).socket();
                    socket3.bind(iaddr);
                    break block7;
                }
                throw runtime2.newErrnoENOPROTOOPTError();
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime2, "bind(2): unknown host");
            }
            catch (SocketException e) {
                throw RubySocket.buildSocketException(runtime2, e, "bind(2)", iaddr);
            }
            catch (IOException e) {
                throw RubySocket.sockerr(runtime2, "bind(2): name or service not known", e);
            }
            catch (IllegalArgumentException e) {
                throw RubySocket.sockerr(runtime2, e.getMessage(), e);
            }
        }
    }

    static RaiseException buildSocketException(Ruby runtime2, SocketException ex, String caller2, SocketAddress addr2) {
        Errno errno2 = Helpers.errnoFromException(ex);
        String callerWithAddr = caller2 + " for " + RubySocket.formatAddress(addr2);
        if (errno2 != null) {
            return runtime2.newErrnoFromErrno(errno2, callerWithAddr);
        }
        String message2 = ex.getMessage();
        if (message2 != null) {
            if (ALREADY_BOUND_PATTERN.matcher(message2).find()) {
                return runtime2.newErrnoEINVALError(callerWithAddr);
            }
            if (ADDR_NOT_AVAIL_PATTERN.matcher(message2).find()) {
                return runtime2.newErrnoEADDRNOTAVAILError(callerWithAddr);
            }
        }
        return runtime2.newIOError(callerWithAddr);
    }

    private static CharSequence formatAddress(SocketAddress addr2) {
        if (addr2 == null) {
            return null;
        }
        String str = addr2.toString();
        if (str.length() > 0 && str.charAt(0) == '/') {
            return str.substring(1);
        }
        return str;
    }

    private SocketAddress addressForChannel(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof Addrinfo) {
            return ((Addrinfo)arg2).getSocketAddress();
        }
        switch (this.soProtocolFamily) {
            case PF_UNIX: 
            case PF_LOCAL: {
                return Sockaddr.addressFromSockaddr_un(context, arg2);
            }
            case PF_INET: 
            case PF_INET6: 
            case PF_UNSPEC: {
                return Sockaddr.addressFromSockaddr_in(context, arg2);
            }
        }
        throw context.runtime.newArgumentError("unsupported protocol family `" + this.soProtocolFamily + "'");
    }

    @Override
    protected IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        Ruby runtime2 = context.runtime;
        return new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), addr2.getAddress(), addr2.getPort(), Sock.SOCK_DGRAM);
    }

    @Override
    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        if (this.getOpenFile() != null) {
            if (this.isClosed()) {
                return context.nil;
            }
            this.openFile.checkClosed();
            return this.rbIoClose(context);
        }
        return context.nil;
    }

    @Override
    public RubyBoolean closed_p(ThreadContext context) {
        if (this.getOpenFile() == null) {
            return context.fals;
        }
        return super.closed_p(context);
    }

    @Override
    protected SocketAddress getSocketAddress() {
        Channel channel = this.getChannel();
        return SocketType.forChannel(channel).getLocalSocketAddress(channel);
    }

    @Deprecated
    public static RuntimeException sockerr(Ruby runtime2, String msg) {
        return SocketUtils.sockerr(runtime2, msg);
    }
}

