/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.objectweb.asm.ClassWriter;

public abstract class ASM {
    private ASM() {
    }

    public static ClassWriter newClassWriter() {
        return new ClassWriter(3);
    }

    public static ClassWriter newClassWriter(ClassLoader loader) {
        return ASM.newClassWriter(loader, 3);
    }

    public static ClassWriter newClassWriter(ClassLoader loader, int flags2) {
        return new ClassLoaderAwareWriter(loader, flags2);
    }

    private static class ClassLoaderAwareWriter
    extends ClassWriter {
        private final ClassLoader loader;

        ClassLoaderAwareWriter(ClassLoader loader, int flags2) {
            super(flags2);
            this.loader = loader != null ? loader : ASM.class.getClassLoader();
        }

        protected String getCommonSuperClass(String type1, String type2) {
            return ClassLoaderAwareWriter.getCommonSuperClassImpl(type1, type2, this.loader);
        }

        private static String getCommonSuperClassImpl(String type1, String type2, ClassLoader loader) throws TypeNotPresentException {
            Class<?> class2;
            Class<?> class1;
            try {
                class1 = Class.forName(type1.replace('/', '.'), false, loader);
            }
            catch (ClassNotFoundException | Error e) {
                throw new TypeNotPresentException(type1, e);
            }
            try {
                class2 = Class.forName(type2.replace('/', '.'), false, loader);
            }
            catch (ClassNotFoundException | Error e) {
                throw new TypeNotPresentException(type2, e);
            }
            if (class1.isAssignableFrom(class2)) {
                return type1;
            }
            if (class2.isAssignableFrom(class1)) {
                return type2;
            }
            if (class1.isInterface() || class2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
    }
}

