/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.FreedMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.ReifyingAllocator;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

@JRubyClass(name={"FFI::MemoryPointer"}, parent="FFI::Pointer")
public class MemoryPointer
extends Pointer {
    public static RubyClass createMemoryPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass memptrClass = module.defineClassUnder("MemoryPointer", module.getClass("Pointer"), (Boolean)Options.REIFY_FFI.load() != false ? new ReifyingAllocator(MemoryPointer.class) : MemoryPointer::new);
        memptrClass.defineAnnotatedMethods(MemoryPointer.class);
        memptrClass.defineAnnotatedConstants(MemoryPointer.class);
        memptrClass.setReifiedClass(MemoryPointer.class);
        memptrClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof MemoryPointer && super.isKindOf(obj, type2);
            }
        };
        return memptrClass;
    }

    public MemoryPointer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private MemoryPointer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long total2, int typeSize) {
        super(runtime2, (RubyClass)klass, io2, total2, typeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IRubyObject init(ThreadContext context, IRubyObject rbTypeSize, int count2, int align, boolean clear2, Block block) {
        this.typeSize = MemoryPointer.calculateTypeSize(context, rbTypeSize);
        this.size = this.typeSize * count2;
        if (this.size < 0L) {
            throw context.runtime.newArgumentError(String.format("Negative size (%d objects of %d size)", count2, this.typeSize));
        }
        this.setMemoryIO(Factory.getInstance().allocateDirectMemory(context.runtime, this.size > 0L ? (int)this.size : 1, align, clear2));
        if (this.getMemoryIO() == null) {
            Ruby runtime2 = context.runtime;
            throw RaiseException.from(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", this.typeSize, count2));
        }
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, this);
                return iRubyObject;
            }
            finally {
                ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).free();
                this.setMemoryIO(new FreedMemoryIO(context.runtime));
            }
        }
        return this;
    }

    static MemoryPointer allocate(Ruby runtime2, int typeSize, int count2, boolean clear2) {
        int total2 = typeSize * count2;
        MemoryIO io2 = Factory.getInstance().allocateDirectMemory(runtime2, total2 > 0 ? total2 : 1, clear2);
        if (io2 == null) {
            throw RaiseException.from(runtime2, runtime2.getNoMemoryError(), String.format("Failed to allocate %d objects of %d bytes", count2, typeSize));
        }
        return new MemoryPointer(runtime2, (IRubyObject)runtime2.getFFI().memptrClass, io2, (long)total2, typeSize);
    }

    @JRubyMethod(name={"from_string"}, meta=true)
    public static IRubyObject from_string(ThreadContext context, IRubyObject klass, IRubyObject s2) {
        ByteList bl = s2.convertToString().getByteList();
        MemoryPointer ptr = (MemoryPointer)((RubyClass)klass).newInstance(context, context.runtime.newFixnum(bl.length() + 1), Block.NULL_BLOCK);
        ptr.getMemoryIO().putZeroTerminatedByteArray(0L, bl.unsafeBytes(), bl.begin(), bl.length());
        return ptr;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, Block block) {
        return sizeArg instanceof RubyFixnum ? this.init(context, RubyFixnum.one(context.runtime), RubyFixnum.fix2int(sizeArg), 1, true, block) : this.init(context, sizeArg, 1, 1, true, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject count2, Block block) {
        return this.init(context, sizeArg, RubyNumeric.fix2int(count2), 1, true, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject count2, IRubyObject clear2, Block block) {
        return this.init(context, sizeArg, RubyNumeric.fix2int(count2), 1, clear2.isTrue(), block);
    }

    @Override
    public final String toString() {
        return String.format("MemoryPointer[address=%#x, size=%d]", this.getAddress(), this.size);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, this == obj || this.getAddress() == 0L && obj.isNil() || obj instanceof MemoryPointer && ((MemoryPointer)obj).getAddress() == this.getAddress() && ((MemoryPointer)obj).getSize() == this.getSize());
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).free();
        this.setMemoryIO(new FreedMemoryIO(context.runtime));
        return context.nil;
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).setAutoRelease(release.isTrue());
        return context.nil;
    }

    @JRubyMethod(name={"autorelease?"})
    public final IRubyObject autorelease_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).isAutoRelease());
    }
}

