/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Enumerator::Chain"})
public class RubyChain
extends RubyObject {
    private IRubyObject[] enums;
    private int pos = -1;

    public static RubyClass createChainClass(Ruby runtime2, RubyClass enumeratorModule) {
        RubyClass chainc = runtime2.defineClassUnder("Chain", runtime2.getObject(), RubyChain::new, enumeratorModule);
        chainc.includeModule(runtime2.getEnumerable());
        chainc.defineAnnotatedMethods(RubyChain.class);
        return chainc;
    }

    public RubyChain(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyChain(Ruby runtime2, RubyClass klass, IRubyObject[] enums) {
        super(runtime2, klass);
        this.enums = enums;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.enums = new IRubyObject[args2.length];
        System.arraycopy(args2, 0, this.enums, 0, args2.length);
        return this;
    }

    public static RubyChain newChain(ThreadContext context, IRubyObject[] enums) {
        return new RubyChain(context.runtime, context.runtime.getChain(), enums);
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", args2, RubyChain::size);
        }
        for (int i2 = 0; i2 < this.enums.length; ++i2) {
            this.pos = i2;
            Helpers.invoke(context, this.enums[i2], "each", args2, block);
        }
        return this;
    }

    private static IRubyObject size(ThreadContext context, RubyChain self2, IRubyObject[] args2) {
        return self2.size(context);
    }

    @JRubyMethod
    public IRubyObject rewind(ThreadContext context) {
        for (int i2 = this.pos; 0 <= i2 && this.pos < this.enums.length; --i2) {
            Helpers.invokeChecked(context, this.enums[i2], "rewind");
            --this.pos;
        }
        return this;
    }

    @Override
    public final IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        ByteList str = new ByteList();
        str.append(35).append(60);
        str.append(this.getMetaClass().getRealClass().getName().getBytes());
        str.append(58).append(32);
        if (this.enums == null) {
            str.append("uninitialized>".getBytes());
            return RubyString.newStringLight(context.runtime, str);
        }
        str.append(91);
        for (int i2 = 0; i2 < this.enums.length - 1; ++i2) {
            str.append(RubyObject.inspect(context, this.enums[i2]).getByteList());
            str.append(44).append(32);
        }
        if (this.enums.length > 0) {
            str.append(RubyObject.inspect(context, this.enums[this.enums.length - 1]).getByteList());
        }
        str.append(93).append(62);
        return RubyString.newStringLight(context.runtime, str);
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        return RubyChain.enumChainTotalSize(context, this.enums);
    }

    private static IRubyObject enumChainTotalSize(ThreadContext context, IRubyObject[] args2) {
        RubyFixnum total2 = RubyFixnum.zero(context.runtime);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject size2;
            IRubyObject iRubyObject = size2 = args2[i2].respondsTo("size") ? args2[i2].callMethod(context, "size") : context.nil;
            if (size2.isNil() || size2 instanceof RubyFloat && size2.equals(context.runtime.getFloat().getConstant("INFINITY"))) {
                return size2;
            }
            if (!(size2 instanceof RubyInteger)) {
                return context.nil;
            }
            total2 = (RubyFixnum)total2.callMethod("+", size2);
        }
        return total2;
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject obj) {
        return RubyChain.newChain(context, new IRubyObject[]{this, obj});
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyChain copy2 = (RubyChain)super.dup();
        copy2.enums = this.enums;
        copy2.pos = this.pos;
        return copy2;
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, Block block) {
        return this.with_index(context, context.nil, block);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, IRubyObject arg2, Block block) {
        int index2;
        Ruby runtime2 = context.runtime;
        int n = index2 = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorizeWithSize(context, this, "with_index", RubyChain::size) : RubyEnumerator.enumeratorizeWithSize(context, this, "with_index", new IRubyObject[]{runtime2.newFixnum(index2)}, RubyChain::size);
        }
        return RubyEnumerable.callEach(context, RubyChain.fiberSites((ThreadContext)context).each, this, (BlockCallback)new RubyEnumerable.EachWithIndex(block, index2));
    }

    private static JavaSites.FiberSites fiberSites(ThreadContext context) {
        return context.sites.Fiber;
    }
}

