/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.Position;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.StringTerm;
import org.jruby.ext.ripper.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList marker;
    private final int flags;
    private final ByteList lastLine;

    public HeredocTerm(ByteList marker, int func, ByteList lastLine) {
        this.marker = marker;
        this.flags = func;
        this.lastLine = lastLine;
    }

    @Override
    public int parseString(RipperLexer lexer, LexerSource src) throws IOException {
        Position position;
        int match2;
        boolean indent;
        boolean bl = indent = (this.flags & 0x20) != 0;
        if (src.peek(-1)) {
            this.syntaxError(src);
            return -1;
        }
        if (src.lastWasBeginOfLine() && (match2 = src.matchMarker(this.marker, indent, true)) != 0) {
            src.unreadMany(this.lastLine);
            if (match2 == 10) {
                this.marker.append(10);
            }
            lexer.addDelayedValue(388, this.marker);
            lexer.ignoreNextScanEvent = true;
            return 372;
        }
        ByteList str = new ByteList();
        str.setEncoding(lexer.getEncoding());
        if ((this.flags & 2) == 0) {
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (src.peek(-1)) {
                    this.syntaxError(src);
                    lexer.addDelayedValue(377, str);
                    return -1;
                }
                position = lexer.getPosition();
            } while ((match2 = src.matchMarker(this.marker, indent, true)) == 0);
        } else {
            int c = src.read();
            if (c == 35) {
                c = src.read();
                switch (c) {
                    case 36: 
                    case 64: {
                        src.unread(c);
                        lexer.setValue(new Token("#", lexer.getPosition()));
                        return 371;
                    }
                    case 123: {
                        lexer.setValue(new Token("#{", lexer.getPosition()));
                        return 370;
                    }
                }
                str.append(35);
            }
            src.unread(c);
            do {
                if ((c = new StringTerm(this.flags, 0, 10).parseStringIntoBuffer(lexer, src, str)) == -1) {
                    this.syntaxError(src);
                }
                if (c != 10) {
                    lexer.addDelayedValue(377, lexer.createStr(lexer.getPosition(), str, 0));
                    lexer.ignoreNextScanEvent = true;
                    return 377;
                }
                str.append(src.read());
                if (src.peek(-1)) {
                    lexer.addDelayedValue(377, lexer.createStr(lexer.getPosition(), str, 0));
                    this.syntaxError(src);
                    return -1;
                }
                position = lexer.getPosition();
            } while ((match2 = src.matchMarker(this.marker, indent, true)) == 0);
        }
        if (match2 == 10) {
            this.marker.append(10);
        }
        src.unreadMany(this.lastLine);
        lexer.setStrTerm(new StringTerm(-1, 0, 0));
        lexer.addDelayedValue(377, lexer.createStr(position, str, 0));
        lexer.addDelayedValue(388, this.marker);
        lexer.ignoreNextScanEvent = true;
        return 377;
    }

    private void syntaxError(LexerSource src) {
    }
}

