/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.commons.LocalVariablesSorter;
import org.jruby.org.objectweb.asm.commons.Remapper;
import org.jruby.org.objectweb.asm.commons.RemappingAnnotationAdapter;

public class RemappingMethodAdapter
extends LocalVariablesSorter {
    protected final Remapper remapper;

    public RemappingMethodAdapter(int n, String string2, MethodVisitor methodVisitor, Remapper remapper) {
        this(262144, n, string2, methodVisitor, remapper);
    }

    protected RemappingMethodAdapter(int n, int n2, String string2, MethodVisitor methodVisitor, Remapper remapper) {
        super(n, n2, string2, methodVisitor);
        this.remapper = remapper;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotation(this.remapper.mapDesc(string2), bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitParameterAnnotation(n, this.remapper.mapDesc(string2), bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        super.visitFrame(n, n2, this.remapEntries(n2, objectArray), n3, this.remapEntries(n3, objectArray2));
    }

    private Object[] remapEntries(int n, Object[] objectArray) {
        for (int j = 0; j < n; ++j) {
            if (!(objectArray[j] instanceof String)) continue;
            Object[] objectArray2 = new Object[n];
            if (j > 0) {
                System.arraycopy(objectArray, 0, objectArray2, 0, j);
            }
            do {
                Object object = objectArray[j];
                Object object2 = objectArray2[j++] = object instanceof String ? this.remapper.mapType((String)object) : object;
            } while (j < n);
            return objectArray2;
        }
        return objectArray;
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        super.visitFieldInsn(n, this.remapper.mapType(string2), this.remapper.mapFieldName(string2, string3, string4), this.remapper.mapDesc(string4));
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        super.visitMethodInsn(n, this.remapper.mapType(string2), this.remapper.mapMethodName(string2, string3, string4), this.remapper.mapMethodDesc(string4));
    }

    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle, Object ... objectArray) {
        for (int j = 0; j < objectArray.length; ++j) {
            objectArray[j] = this.remapper.mapValue(objectArray[j]);
        }
        super.visitInvokeDynamicInsn(this.remapper.mapInvokeDynamicMethodName(string2, string3), this.remapper.mapMethodDesc(string3), (Handle)this.remapper.mapValue(handle), objectArray);
    }

    public void visitTypeInsn(int n, String string2) {
        super.visitTypeInsn(n, this.remapper.mapType(string2));
    }

    public void visitLdcInsn(Object object) {
        super.visitLdcInsn(this.remapper.mapValue(object));
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(string2), n);
    }

    public void visitTryCatchBlock(Label label2, Label label3, Label label4, String string2) {
        super.visitTryCatchBlock(label2, label3, label4, string2 == null ? null : this.remapper.mapType(string2));
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label2, Label label3, int n) {
        super.visitLocalVariable(string2, this.remapper.mapDesc(string3), this.remapper.mapSignature(string4, true), label2, label3, n);
    }
}

