/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.invoke.SwitchPoint;
import java.util.List;
import org.jruby.runtime.opto.Invalidator;

public class FailoverSwitchPointInvalidator
implements Invalidator {
    private static final SwitchPoint DUMMY = new SwitchPoint();
    private volatile SwitchPoint switchPoint = DUMMY;
    private volatile int failures;
    private final int maxFailures;

    public FailoverSwitchPointInvalidator(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    @Override
    public synchronized void invalidate() {
        if (this.switchPoint == DUMMY) {
            return;
        }
        ++this.failures;
        if (this.failures > this.maxFailures) {
            this.switchPoint = DUMMY;
            return;
        }
        SwitchPoint.invalidateAll(new SwitchPoint[]{this.switchPoint});
        this.switchPoint = new SwitchPoint();
    }

    @Override
    public void invalidateAll(List<Invalidator> invalidators) {
        SwitchPoint[] switchPoints = new SwitchPoint[invalidators.size()];
        for (int i2 = 0; i2 < invalidators.size(); ++i2) {
            Invalidator invalidator = invalidators.get(i2);
            assert (invalidator instanceof FailoverSwitchPointInvalidator);
            switchPoints[i2] = ((FailoverSwitchPointInvalidator)invalidator).replaceSwitchPoint();
        }
        SwitchPoint.invalidateAll(switchPoints);
    }

    @Override
    public synchronized Object getData() {
        return this.switchPoint == DUMMY && this.failures <= this.maxFailures ? (this.switchPoint = new SwitchPoint()) : this.switchPoint;
    }

    public synchronized SwitchPoint replaceSwitchPoint() {
        if (this.switchPoint == DUMMY || this.failures > this.maxFailures) {
            return DUMMY;
        }
        SwitchPoint oldSwitchPoint = this.switchPoint;
        this.switchPoint = new SwitchPoint();
        return oldSwitchPoint;
    }

    static {
        SwitchPoint.invalidateAll(new SwitchPoint[]{DUMMY});
    }
}

