/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.rules.RuleFactory;

public class SchemaMapper {
    private static final JsonNodeFactory NODE_FACTORY = JsonNodeFactory.instance;
    private final RuleFactory ruleFactory;
    private final SchemaGenerator schemaGenerator;

    public SchemaMapper(RuleFactory ruleFactory, SchemaGenerator schemaGenerator) {
        this.ruleFactory = ruleFactory;
        this.schemaGenerator = schemaGenerator;
    }

    public SchemaMapper() {
        this(new RuleFactory(), new SchemaGenerator());
    }

    public JType generate(JCodeModel codeModel, String className, String packageName, URL schemaUrl) throws IOException {
        JPackage jpackage = codeModel._package(packageName);
        ObjectNode schemaNode = this.readSchema(schemaUrl);
        return this.ruleFactory.getSchemaRule().apply(className, (JsonNode)schemaNode, (JClassContainer)jpackage, new Schema(null, (JsonNode)schemaNode));
    }

    private ObjectNode readSchema(URL schemaUrl) {
        switch (this.ruleFactory.getGenerationConfig().getSourceType()) {
            case JSONSCHEMA: {
                ObjectNode schemaNode = NODE_FACTORY.objectNode();
                schemaNode.put("$ref", schemaUrl.toString());
                return schemaNode;
            }
            case JSON: {
                return this.schemaGenerator.schemaFromExample(schemaUrl);
            }
        }
        throw new IllegalArgumentException("Unrecognised source type: " + (Object)((Object)this.ruleFactory.getGenerationConfig().getSourceType()));
    }

    public JType generate(JCodeModel codeModel, String className, String packageName, String json, URI schemaLocation) throws IOException {
        JPackage jpackage = codeModel._package(packageName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(json);
        return this.ruleFactory.getSchemaRule().apply(className, schemaNode, (JClassContainer)jpackage, new Schema(schemaLocation, schemaNode));
    }

    public JType generate(JCodeModel codeModel, String className, String packageName, String json) throws IOException {
        JPackage jpackage = codeModel._package(packageName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode schemaNode = mapper.readTree(json);
        return this.ruleFactory.getSchemaRule().apply(className, schemaNode, (JClassContainer)jpackage, new Schema(null, schemaNode));
    }
}

