/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JType;
import java.net.URI;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class FormatRule
implements Rule<JType, JType> {
    private final RuleFactory ruleFactory;

    protected FormatRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JType baseType, Schema schema) {
        if (node.asText().equals("date-time")) {
            return baseType.owner().ref(this.getDateTimeType());
        }
        if (node.asText().equals("date")) {
            return baseType.owner().ref(this.getDateOnlyType());
        }
        if (node.asText().equals("time")) {
            return baseType.owner().ref(this.getTimeOnlyType());
        }
        if (node.asText().equals("utc-millisec")) {
            return this.unboxIfNecessary((JType)baseType.owner().ref(Long.class), this.ruleFactory.getGenerationConfig());
        }
        if (node.asText().equals("regex")) {
            return baseType.owner().ref(Pattern.class);
        }
        if (node.asText().equals("color")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("style")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("phone")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("uri")) {
            return baseType.owner().ref(URI.class);
        }
        if (node.asText().equals("email")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("ip-address")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("ipv6")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("host-name")) {
            return baseType.owner().ref(String.class);
        }
        if (node.asText().equals("uuid")) {
            return baseType.owner().ref(UUID.class);
        }
        return baseType;
    }

    private Class<?> getDateTimeType() {
        return this.ruleFactory.getGenerationConfig().isUseJodaDates() ? DateTime.class : Date.class;
    }

    private Class<?> getDateOnlyType() {
        return this.ruleFactory.getGenerationConfig().isUseJodaLocalDates() ? LocalDate.class : String.class;
    }

    private Class<?> getTimeOnlyType() {
        return this.ruleFactory.getGenerationConfig().isUseJodaLocalTimes() ? LocalTime.class : String.class;
    }

    private JType unboxIfNecessary(JType type, GenerationConfig config) {
        if (config.isUsePrimitives()) {
            return type.unboxify();
        }
        return type;
    }
}

