/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.exception.ClassAlreadyExistsException;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.TypeUtil;

public class EnumRule
implements Rule<JClassContainer, JType> {
    private static final String VALUE_FIELD_NAME = "value";
    private final RuleFactory ruleFactory;

    protected EnumRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JClassContainer container, Schema schema) {
        JDefinedClass _enum;
        try {
            _enum = this.createEnum(node, nodeName, container);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        schema.setJavaTypeIfEmpty((JType)_enum);
        if (node.has("javaInterfaces")) {
            this.addInterfaces(_enum, node.get("javaInterfaces"));
        }
        this.addGeneratedAnnotation(_enum);
        JFieldVar valueField = this.addValueField(_enum);
        this.addToString(_enum, valueField);
        this.addEnumConstants(node.path("enum"), _enum, node.path("javaEnumNames"));
        this.addFactoryMethod(_enum);
        return _enum;
    }

    /*
     * Loose catch block
     */
    private JDefinedClass createEnum(JsonNode node, String nodeName, JClassContainer container) throws ClassAlreadyExistsException {
        int modifiers;
        block8: {
            modifiers = container.isPackage() ? 1 : 17;
            if (!node.has("javaType")) break block8;
            String fqn = node.get("javaType").asText();
            if (PrimitiveTypes.isPrimitive(fqn, container.owner())) {
                throw new GenerationException("Primitive type '" + fqn + "' cannot be used as an enum.");
            }
            try {
                Class<?> existingClass = Thread.currentThread().getContextClassLoader().loadClass(fqn);
                throw new ClassAlreadyExistsException((JType)container.owner().ref(existingClass));
            }
            catch (ClassNotFoundException e) {
                return container.owner()._class(fqn, ClassType.ENUM);
            }
            {
                catch (JClassAlreadyExistsException e) {
                    throw new ClassAlreadyExistsException((JType)e.getExistingClass());
                }
            }
        }
        try {
            return container._class(modifiers, this.getEnumName(nodeName, container), ClassType.ENUM);
        }
        catch (JClassAlreadyExistsException e) {
            throw new GenerationException(e);
        }
    }

    private void addFactoryMethod(JDefinedClass _enum) {
        JFieldVar quickLookupMap = this.addQuickLookupMap(_enum);
        JMethod fromValue = _enum.method(17, (JType)_enum, "fromValue");
        JVar valueParam = fromValue.param(String.class, VALUE_FIELD_NAME);
        JBlock body = fromValue.body();
        JVar constant = body.decl((JType)_enum, "constant");
        constant.init((JExpression)quickLookupMap.invoke("get").arg((JExpression)valueParam));
        JConditional _if = body._if(constant.eq(JExpr._null()));
        JInvocation illegalArgumentException = JExpr._new((JClass)_enum.owner().ref(IllegalArgumentException.class));
        illegalArgumentException.arg((JExpression)valueParam);
        _if._then()._throw((JExpression)illegalArgumentException);
        _if._else()._return((JExpression)constant);
        this.ruleFactory.getAnnotator().enumCreatorMethod(fromValue);
    }

    private JFieldVar addQuickLookupMap(JDefinedClass _enum) {
        JClass lookupType = _enum.owner().ref(Map.class).narrow(new JClass[]{_enum.owner().ref(String.class), _enum});
        JFieldVar lookupMap = _enum.field(28, (JType)lookupType, "CONSTANTS");
        JClass lookupImplType = _enum.owner().ref(HashMap.class).narrow(new JClass[]{_enum.owner().ref(String.class), _enum});
        lookupMap.init((JExpression)JExpr._new((JClass)lookupImplType));
        JForEach forEach = _enum.init().forEach((JType)_enum, "c", (JExpression)JExpr.invoke((String)"values"));
        JInvocation put = forEach.body().invoke((JExpression)lookupMap, "put");
        put.arg((JExpression)forEach.var().ref(VALUE_FIELD_NAME));
        put.arg((JExpression)forEach.var());
        return lookupMap;
    }

    private JFieldVar addValueField(JDefinedClass _enum) {
        JFieldVar valueField = _enum.field(12, String.class, VALUE_FIELD_NAME);
        JMethod constructor = _enum.constructor(4);
        JVar valueParam = constructor.param(String.class, VALUE_FIELD_NAME);
        JBlock body = constructor.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)valueField), (JExpression)valueParam);
        return valueField;
    }

    private void addToString(JDefinedClass _enum, JFieldVar valueField) {
        JMethod toString = _enum.method(1, String.class, "toString");
        JBlock body = toString.body();
        body._return((JExpression)JExpr._this().ref((JVar)valueField));
        this.ruleFactory.getAnnotator().enumValueMethod(toString);
        toString.annotate(Override.class);
    }

    private void addEnumConstants(JsonNode node, JDefinedClass _enum, JsonNode customNames) {
        for (int i = 0; i < node.size(); ++i) {
            JsonNode value = node.path(i);
            if (value.isNull()) continue;
            JEnumConstant constant = _enum.enumConstant(this.getConstantName(value.asText(), customNames.path(i).asText()));
            constant.arg(JExpr.lit((String)value.asText()));
            this.ruleFactory.getAnnotator().enumConstant(constant, value.asText());
        }
    }

    private void addGeneratedAnnotation(JDefinedClass jclass) {
        JAnnotationUse generated = jclass.annotate(Generated.class);
        generated.param(VALUE_FIELD_NAME, SchemaMapper.class.getPackage().getName());
    }

    private String getEnumName(String nodeName, JClassContainer container) {
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(StringUtils.capitalize((String)nodeName));
        String normalizedName = this.ruleFactory.getNameHelper().normalizeName(className);
        return this.makeUnique(normalizedName, container);
    }

    private String makeUnique(String className, JClassContainer container) {
        boolean found = false;
        Iterator classes = container.classes();
        while (classes.hasNext()) {
            JDefinedClass aClass = (JDefinedClass)classes.next();
            if (!className.equalsIgnoreCase(aClass.name())) continue;
            found = true;
            break;
        }
        if (found) {
            className = this.makeUnique(className + "_", container);
        }
        return className;
    }

    protected String getConstantName(String nodeName, String customName) {
        if (StringUtils.isNotBlank((CharSequence)customName)) {
            return customName;
        }
        ArrayList<String> enumNameGroups = new ArrayList<String>(Arrays.asList(StringUtils.splitByCharacterTypeCamelCase((String)nodeName)));
        String enumName = "";
        Iterator iter = enumNameGroups.iterator();
        while (iter.hasNext()) {
            if (!StringUtils.containsOnly((CharSequence)this.ruleFactory.getNameHelper().replaceIllegalCharacters((String)iter.next()), (String)"_")) continue;
            iter.remove();
        }
        enumName = StringUtils.upperCase((String)StringUtils.join(enumNameGroups, (String)"_"));
        if (StringUtils.isEmpty((CharSequence)enumName)) {
            enumName = "__EMPTY__";
        } else if (Character.isDigit(enumName.charAt(0))) {
            enumName = "_" + enumName;
        }
        return enumName;
    }

    private void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(TypeUtil.resolveType(jclass._package(), i.asText()));
        }
    }
}

