/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private static final Pattern UNDERSCORE_PATTERN_1 = Pattern.compile("([A-Z]+)([A-Z][a-z])");
    private static final Pattern UNDERSCORE_PATTERN_2 = Pattern.compile("([a-z\\d])([A-Z])");
    private final List<RuleAndReplacement> plurals;
    private final List<RuleAndReplacement> singulars;
    private final List<String> uncountables;
    private static Inflector instance = Inflector.createDefaultBuilder().build();

    private Inflector(Builder builder) {
        this.plurals = Collections.unmodifiableList(builder.plurals);
        this.singulars = Collections.unmodifiableList(builder.singulars);
        this.uncountables = Collections.unmodifiableList(builder.uncountables);
    }

    public static Builder createDefaultBuilder() {
        Builder builder = Inflector.builder();
        builder.plural("$", "s").plural("s$", "s").plural("(ax|test)is$", "$1es").plural("(octop|vir)us$", "$1i").plural("(alias|status)$", "$1es").plural("(bu)s$", "$1es").plural("(buffal|tomat)o$", "$1oes").plural("([ti])um$", "$1a").plural("sis$", "ses").plural("(?:([^f])fe|([lr])f)$", "$1$2ves").plural("(database|hive)$", "$1s").plural("([^aeiouy]|qu)y$", "$1ies").plural("([^aeiouy]|qu)ies$", "$1y").plural("(x|ch|ss|sh)$", "$1es").plural("(matr|vert|ind)ix|ex$", "$1ices").plural("([m|l])ouse$", "$1ice").plural("(ox)$", "$1en").plural("(quiz)$", "$1zes");
        builder.singular("s$", "").singular("(n)ews$", "$1ews").singular("([ti])a$", "$1um").singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis").singular("(^analy)ses$", "$1sis").singular("([^f])ves$", "$1fe").singular("(database|hive)s$", "$1").singular("(tive)s$", "$1").singular("([lr])ves$", "$1f").singular("([^aeiouy]|qu)ies$", "$1y").singular("(s)eries$", "$1eries").singular("(m)ovies$", "$1ovie").singular("(x|ch|ss|sh)es$", "$1").singular("([m|l])ice$", "$1ouse").singular("(bus)es$", "$1").singular("(o)es$", "$1").singular("(shoe)s$", "$1").singular("(cris|ax|test)es$", "$1is").singular("([octop|vir])i$", "$1us").singular("(alias|status)es$", "$1").singular("^(ox)en", "$1").singular("(vert|ind)ices$", "$1ex").singular("(matr)ices$", "$1ix").singular("(quiz)zes$", "$1").singular("(ess)$", "$1");
        builder.singular("men$", "man").plural("man$", "men").singular("specimen", "specimen").plural("specimen", "specimens");
        builder.irregular("curve", "curves").irregular("leaf", "leaves").irregular("roof", "rooves").irregular("person", "people").irregular("child", "children").irregular("sex", "sexes").irregular("move", "moves");
        builder.uncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep", "s");
        return builder;
    }

    public static Inflector getInstance() {
        return instance;
    }

    private String underscore(String camelCasedWord) {
        String underscoredWord = UNDERSCORE_PATTERN_1.matcher(camelCasedWord).replaceAll("$1_$2");
        underscoredWord = UNDERSCORE_PATTERN_2.matcher(underscoredWord).replaceAll("$1_$2");
        underscoredWord = underscoredWord.replace('-', '_').toLowerCase();
        return underscoredWord;
    }

    public String pluralize(String word) {
        if (this.uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return Inflector.replaceWithFirstRule(word, this.plurals);
    }

    public String singularize(String word) {
        if (this.uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return Inflector.replaceWithFirstRule(word, this.singulars);
    }

    private static String replaceWithFirstRule(String word, List<RuleAndReplacement> ruleAndReplacements) {
        for (RuleAndReplacement rar : ruleAndReplacements) {
            String replacement = rar.getReplacement();
            Matcher matcher = rar.getPattern().matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceAll(replacement);
        }
        return word;
    }

    private String tableize(String className) {
        return this.pluralize(this.underscore(className));
    }

    private String tableize(Class<?> klass) {
        String className = klass.getName().replace(klass.getPackage().getName() + ".", "");
        return this.tableize(className);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<RuleAndReplacement> plurals = new ArrayList<RuleAndReplacement>();
        private List<RuleAndReplacement> singulars = new ArrayList<RuleAndReplacement>();
        private List<String> uncountables = new ArrayList<String>();

        public Builder plural(String rule, String replacement) {
            this.plurals.add(0, new RuleAndReplacement(rule, replacement));
            return this;
        }

        public Builder singular(String rule, String replacement) {
            this.singulars.add(0, new RuleAndReplacement(rule, replacement));
            return this;
        }

        public Builder irregular(String singular, String plural) {
            this.plural(singular, plural);
            this.singular(plural, singular);
            return this;
        }

        public Builder uncountable(String ... words) {
            for (String word : words) {
                this.uncountables.add(word);
            }
            return this;
        }

        public Inflector build() {
            return new Inflector(this);
        }
    }

    private static class RuleAndReplacement {
        private final String rule;
        private final String replacement;
        private final Pattern pattern;

        public RuleAndReplacement(String rule, String replacement) {
            this.rule = rule;
            this.replacement = replacement;
            this.pattern = Pattern.compile(rule, 2);
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String getRule() {
            return this.rule;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

