/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.util.List;
import java.util.Set;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.Inflector;

public class ArrayRule
implements Rule<JPackage, JClass> {
    private final RuleFactory ruleFactory;

    protected ArrayRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JClass apply(String nodeName, JsonNode node, JPackage jpackage, Schema schema) {
        boolean uniqueItems = node.has("uniqueItems") && node.get("uniqueItems").asBoolean();
        boolean rootSchemaIsArray = !schema.isGenerated();
        Object itemType = node.has("items") ? this.ruleFactory.getSchemaRule().apply(this.makeSingular(nodeName), node.get("items"), (JClassContainer)jpackage, schema) : jpackage.owner().ref(Object.class);
        JClass arrayType = uniqueItems ? jpackage.owner().ref(Set.class).narrow((JType)itemType) : jpackage.owner().ref(List.class).narrow((JType)itemType);
        if (rootSchemaIsArray) {
            schema.setJavaType((JType)arrayType);
        }
        return arrayType;
    }

    private String makeSingular(String nodeName) {
        return Inflector.getInstance().singularize(nodeName);
    }
}

