/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.ContentResolver;
import org.jsonschema2pojo.FragmentResolver;
import org.jsonschema2pojo.Schema;

public class SchemaStore {
    protected Map<URI, Schema> schemas = new HashMap<URI, Schema>();
    protected FragmentResolver fragmentResolver = new FragmentResolver();
    protected ContentResolver contentResolver = new ContentResolver();

    public synchronized Schema create(URI id, String refFragmentPathDelimiters) {
        if (!this.schemas.containsKey(id)) {
            JsonNode content = this.contentResolver.resolve(this.removeFragment(id));
            if (id.toString().contains("#")) {
                JsonNode childContent = this.fragmentResolver.resolve(content, '#' + id.getFragment(), refFragmentPathDelimiters);
                this.schemas.put(id, new Schema(id, childContent, content));
            } else {
                this.schemas.put(id, new Schema(id, content, content));
            }
        }
        return this.schemas.get(id);
    }

    protected URI removeFragment(URI id) {
        return URI.create(StringUtils.substringBefore((String)id.toString(), (String)"#"));
    }

    public Schema create(Schema parent, String path, String refFragmentPathDelimiters) {
        URI id;
        String stringId;
        if (!path.equals("#")) {
            path = StringUtils.stripEnd((String)path, (String)"#?&/");
        }
        if (path.contains("#")) {
            URI fragmentURI;
            String pathExcludingFragment = StringUtils.substringBefore((String)path, (String)"#");
            String fragment = StringUtils.substringAfter((String)path, (String)"#");
            try {
                fragmentURI = new URI(null, null, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid fragment: " + fragment + " in path: " + path);
            }
            path = pathExcludingFragment + "#" + fragmentURI.getRawFragment();
        }
        if ((stringId = (id = parent == null || parent.getId() == null ? URI.create(path) : parent.getId().resolve(path)).toString()).endsWith("#")) {
            try {
                id = new URI(StringUtils.stripEnd((String)stringId, (String)"#"));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Bad path: " + stringId);
            }
        }
        if (this.selfReferenceWithoutParentFile(parent, path) || StringUtils.substringBefore((String)stringId, (String)"#").isEmpty()) {
            this.schemas.put(id, new Schema(id, this.fragmentResolver.resolve(parent.getParentContent(), path, refFragmentPathDelimiters), parent.getParentContent()));
            return this.schemas.get(id);
        }
        return this.create(id, refFragmentPathDelimiters);
    }

    protected boolean selfReferenceWithoutParentFile(Schema parent, String path) {
        return parent != null && (parent.getId() == null || parent.getId().toString().startsWith("#/")) && path.startsWith("#/");
    }

    public synchronized void clearCache() {
        this.schemas.clear();
    }
}

