/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.ContentResolver;
import org.jsonschema2pojo.FragmentResolver;
import org.jsonschema2pojo.Schema;

public class SchemaStore {
    protected final Map<URI, Schema> schemas = new HashMap<URI, Schema>();
    protected final FragmentResolver fragmentResolver = new FragmentResolver();
    protected final ContentResolver contentResolver;

    public SchemaStore() {
        this.contentResolver = new ContentResolver();
    }

    public SchemaStore(ContentResolver contentResolver) {
        this.contentResolver = contentResolver;
    }

    public synchronized Schema create(URI id, String refFragmentPathDelimiters) {
        URI normalizedId = id.normalize();
        if (!this.schemas.containsKey(normalizedId)) {
            URI baseId = this.removeFragment(id).normalize();
            JsonNode baseContent = this.contentResolver.resolve(baseId);
            Schema baseSchema = new Schema(baseId, baseContent, null);
            if (normalizedId.toString().contains("#")) {
                JsonNode childContent = this.fragmentResolver.resolve(baseContent, '#' + id.getFragment(), refFragmentPathDelimiters);
                this.schemas.put(normalizedId, new Schema(normalizedId, childContent, baseSchema));
            } else {
                this.schemas.put(normalizedId, baseSchema);
            }
        }
        return this.schemas.get(normalizedId);
    }

    protected URI removeFragment(URI id) {
        return URI.create(StringUtils.substringBefore((String)id.toString(), (String)"#"));
    }

    public Schema create(Schema parent, String path, String refFragmentPathDelimiters) {
        URI id;
        String stringId;
        if (!path.equals("#")) {
            path = StringUtils.stripEnd((String)path, (String)"#?&/");
        }
        if (path.contains("#")) {
            URI fragmentURI;
            String pathExcludingFragment = StringUtils.substringBefore((String)path, (String)"#");
            String fragment = StringUtils.substringAfter((String)path, (String)"#");
            try {
                fragmentURI = new URI(null, null, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid fragment: " + fragment + " in path: " + path);
            }
            path = pathExcludingFragment + "#" + fragmentURI.getRawFragment();
        }
        if ((stringId = (id = parent == null || parent.getId() == null ? URI.create(path) : parent.getId().resolve(path)).toString()).endsWith("#")) {
            try {
                id = new URI(StringUtils.stripEnd((String)stringId, (String)"#"));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Bad path: " + stringId);
            }
        }
        if (this.selfReferenceWithoutParentFile(parent, path) || StringUtils.substringBefore((String)stringId, (String)"#").isEmpty()) {
            JsonNode parentContent = parent.getGrandParent().getContent();
            if (this.schemas.containsKey(id)) {
                return this.schemas.get(id);
            }
            Schema schema = new Schema(id, this.fragmentResolver.resolve(parentContent, path, refFragmentPathDelimiters), parent.getGrandParent());
            this.schemas.put(id, schema);
            return schema;
        }
        return this.create(id, refFragmentPathDelimiters);
    }

    protected boolean selfReferenceWithoutParentFile(Schema parent, String path) {
        return parent != null && (parent.getId() == null || parent.getId().toString().startsWith("#/")) && path.startsWith("#");
    }

    public synchronized void clearCache() {
        this.schemas.clear();
    }
}

