/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.environment;

import com.google.common.base.Optional;
import java.util.Map;
import org.jtwig.escape.environment.EscapeEnvironment;
import org.jtwig.functions.resolver.FunctionResolver;
import org.jtwig.parser.JtwigParser;
import org.jtwig.property.environment.PropertyResolverEnvironment;
import org.jtwig.render.environment.RenderEnvironment;
import org.jtwig.render.expression.calculator.enumerated.EnumerationListStrategy;
import org.jtwig.resource.environment.ResourceEnvironment;
import org.jtwig.value.environment.ValueEnvironment;

public class Environment {
    private final JtwigParser parser;
    private final Map<String, Object> parameters;
    private final ResourceEnvironment resourceEnvironment;
    private final FunctionResolver functionResolver;
    private final PropertyResolverEnvironment propertyResolverEnvironment;
    private final RenderEnvironment renderEnvironment;
    private final ValueEnvironment valueEnvironment;
    private final EnumerationListStrategy enumerationStrategy;
    private final EscapeEnvironment escapeEnvironment;

    public Environment(JtwigParser parser, Map<String, Object> parameters, ResourceEnvironment resourceEnvironment, FunctionResolver functionResolver, PropertyResolverEnvironment propertyResolverEnvironment, RenderEnvironment renderEnvironment, ValueEnvironment valueEnvironment, EnumerationListStrategy enumerationStrategy, EscapeEnvironment escapeEnvironment) {
        this.parser = parser;
        this.parameters = parameters;
        this.resourceEnvironment = resourceEnvironment;
        this.functionResolver = functionResolver;
        this.propertyResolverEnvironment = propertyResolverEnvironment;
        this.renderEnvironment = renderEnvironment;
        this.valueEnvironment = valueEnvironment;
        this.enumerationStrategy = enumerationStrategy;
        this.escapeEnvironment = escapeEnvironment;
    }

    public JtwigParser getParser() {
        return this.parser;
    }

    public ResourceEnvironment getResourceEnvironment() {
        return this.resourceEnvironment;
    }

    public FunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public PropertyResolverEnvironment getPropertyResolverEnvironment() {
        return this.propertyResolverEnvironment;
    }

    public RenderEnvironment getRenderEnvironment() {
        return this.renderEnvironment;
    }

    public EscapeEnvironment getEscapeEnvironment() {
        return this.escapeEnvironment;
    }

    public <T> T parameter(String name, T defaultValue) {
        return (T)Optional.fromNullable((Object)this.parameters.get(name)).or(defaultValue);
    }

    public <T> T parameter(String name) {
        Optional optional = Optional.fromNullable((Object)this.parameters.get(name));
        if (optional.isPresent()) {
            return (T)optional.get();
        }
        throw new IllegalArgumentException(String.format("No property found with name '%s'", name));
    }

    public EnumerationListStrategy getListEnumerationStrategy() {
        return this.enumerationStrategy;
    }

    public ValueEnvironment getValueEnvironment() {
        return this.valueEnvironment;
    }
}

