/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.strategy.method;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.jtwig.property.strategy.method.argument.group.ArgumentGroup;
import org.jtwig.property.strategy.method.argument.group.GroupingArgumentsService;
import org.jtwig.property.strategy.method.convert.Converter;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethod;

public class ArgumentsConverter {
    private final Converter converter;
    private final GroupingArgumentsService groupingArgumentsService;

    public ArgumentsConverter(Converter converter, GroupingArgumentsService groupingArgumentsService) {
        this.converter = converter;
        this.groupingArgumentsService = groupingArgumentsService;
    }

    public Optional<Object[]> convert(JavaMethod method, Object[] objects) {
        Optional<List<ArgumentGroup>> groupArguments = this.groupingArgumentsService.groupArguments(method, objects);
        if (groupArguments.isPresent()) {
            List argumentGroups = (List)groupArguments.get();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (ArgumentGroup argumentGroup : argumentGroups) {
                Optional<Value> argumentValue = argumentGroup.toArgument(this.converter);
                if (argumentValue.isPresent()) {
                    argumentValues.add(((Value)argumentValue.get()).getValue());
                    continue;
                }
                return Optional.absent();
            }
            return Optional.of((Object)argumentValues.toArray());
        }
        return Optional.absent();
    }
}

