/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression.calculator.operation.binary.calculators;

import java.math.BigDecimal;
import org.jtwig.exceptions.CalculationException;
import org.jtwig.model.position.Position;
import org.jtwig.render.RenderRequest;
import org.jtwig.render.expression.calculator.operation.binary.calculators.SimpleBinaryMathCalculator;
import org.jtwig.render.expression.calculator.operation.binary.calculators.SimpleBinaryOperationCalculator;
import org.jtwig.util.ErrorMessageFormatter;
import org.jtwig.value.convert.Converter;

public class MathOperationCalculator
implements SimpleBinaryOperationCalculator {
    private final SimpleBinaryMathCalculator simpleBinaryMathCalculator;

    public MathOperationCalculator(SimpleBinaryMathCalculator simpleBinaryMathCalculator) {
        this.simpleBinaryMathCalculator = simpleBinaryMathCalculator;
    }

    @Override
    public Object calculate(RenderRequest request, Position position, Object left, Object right) {
        Converter<BigDecimal> numberConverter = request.getEnvironment().getValueEnvironment().getNumberConverter();
        Converter.Result<BigDecimal> leftNumber = numberConverter.convert(left);
        if (!leftNumber.isDefined()) {
            throw new CalculationException(ErrorMessageFormatter.errorMessage(position, "Left argument expected to be a number"));
        }
        Converter.Result<BigDecimal> rightNumber = numberConverter.convert(right);
        if (!rightNumber.isDefined()) {
            throw new CalculationException(ErrorMessageFormatter.errorMessage(position, "Right argument expected to be a number"));
        }
        return this.simpleBinaryMathCalculator.calculate(request, leftNumber.get(), rightNumber.get());
    }
}

