/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.resource.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtwig.resource.ResourceService;
import org.jtwig.resource.config.ResourceConfiguration;
import org.jtwig.resource.environment.ResourceEnvironment;
import org.jtwig.resource.loader.CompositeResourceLoader;
import org.jtwig.resource.loader.ResourceLoader;
import org.jtwig.resource.loader.TypedResourceLoader;

public class ResourceEnvironmentFactory {
    public ResourceEnvironment create(ResourceConfiguration resourceConfiguration) {
        List<TypedResourceLoader> resourceLoaders = resourceConfiguration.getResourceLoaders();
        Map<String, ResourceLoader> resourceLoaderMap = this.resourceLoaderListToMap(resourceLoaders);
        ResourceService resourceService = new ResourceService(resourceLoaderMap, resourceLoaders, resourceConfiguration.getAbsoluteResourceTypes(), resourceConfiguration.getRelativeResourceResolvers(), resourceConfiguration.getResourceReferenceExtractor());
        return new ResourceEnvironment(resourceConfiguration.getDefaultCharset(), resourceService, resourceConfiguration.getResourceReferenceExtractor());
    }

    private Map<String, ResourceLoader> resourceLoaderListToMap(List<TypedResourceLoader> resourceLoaders) {
        HashMap loaders = new HashMap();
        for (TypedResourceLoader resourceLoader : resourceLoaders) {
            if (!loaders.containsKey(resourceLoader.getType())) {
                loaders.put(resourceLoader.getType(), new ArrayList());
            }
            ((List)loaders.get(resourceLoader.getType())).add(resourceLoader.getResourceLoader());
        }
        HashMap<String, ResourceLoader> result = new HashMap<String, ResourceLoader>();
        for (Map.Entry entry : loaders.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) {
                result.put((String)entry.getKey(), (ResourceLoader)((List)entry.getValue()).get(0));
                continue;
            }
            result.put((String)entry.getKey(), new CompositeResourceLoader((Collection)entry.getValue()));
        }
        return result;
    }
}

