/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestClassOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultClassDescriptor;
import org.junit.jupiter.engine.discovery.DefaultClassOrdererContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.LruCache;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class ClassOrderingVisitor
extends AbstractOrderingVisitor {
    private final LruCache<ClassBasedTestDescriptor, AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor>> ordererCache = new LruCache(10);
    private final JupiterConfiguration configuration;
    private final AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> globalOrderer;
    private final DiscoveryIssueReporter.Condition<ClassBasedTestDescriptor> noOrderAnnotation;

    ClassOrderingVisitor(JupiterConfiguration configuration, DiscoveryIssueReporter issueReporter) {
        super(issueReporter);
        this.configuration = configuration;
        this.globalOrderer = this.createGlobalOrderer(configuration);
        this.noOrderAnnotation = issueReporter.createReportingCondition(testDescriptor -> !AnnotationSupport.isAnnotated(testDescriptor.getTestClass(), Order.class), testDescriptor -> {
            String message = "Ineffective @Order annotation on class '%s'. It will not be applied because ClassOrderer.OrderAnnotation is not in use.".formatted(testDescriptor.getTestClass().getName());
            return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.INFO, (String)message).source((TestSource)ClassSource.from(testDescriptor.getTestClass())).build();
        });
    }

    public void visit(TestDescriptor testDescriptor) {
        this.doWithMatchingDescriptor(JupiterEngineDescriptor.class, testDescriptor, this::orderTopLevelClasses, descriptor -> "Failed to order top-level classes");
        this.doWithMatchingDescriptor(ClassBasedTestDescriptor.class, testDescriptor, this::orderNestedClasses, descriptor -> "Failed to order nested classes for " + String.valueOf(descriptor.getTestClass()));
    }

    @Override
    protected boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes() {
        return true;
    }

    private void orderTopLevelClasses(JupiterEngineDescriptor engineDescriptor) {
        this.orderChildrenTestDescriptors((TestDescriptor)engineDescriptor, ClassBasedTestDescriptor.class, this.toValidationAction(this.globalOrderer), DefaultClassDescriptor::new, this.globalOrderer);
    }

    private void orderNestedClasses(ClassBasedTestDescriptor descriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> wrapperOrderer = this.createAndCacheClassLevelOrderer(descriptor);
        this.orderChildrenTestDescriptors(descriptor, ClassBasedTestDescriptor.class, this.toValidationAction(wrapperOrderer), DefaultClassDescriptor::new, wrapperOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> createGlobalOrderer(JupiterConfiguration configuration) {
        ClassOrderer classOrderer = configuration.getDefaultTestClassOrderer().orElse(null);
        return classOrderer == null ? AbstractOrderingVisitor.DescriptorWrapperOrderer.noop() : this.createDescriptorWrapperOrderer(classOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> createAndCacheClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> orderer = this.createClassLevelOrderer(classBasedTestDescriptor);
        this.ordererCache.put((Object)classBasedTestDescriptor, orderer);
        return orderer;
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> createClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        return AnnotationSupport.findAnnotation(classBasedTestDescriptor.getTestClass(), TestClassOrder.class).map(TestClassOrder::value).map(x$0 -> (ClassOrderer)ReflectionSupport.newInstance((Class)x$0, (Object[])new Object[0])).map(this::createDescriptorWrapperOrderer).orElseGet(() -> {
            Object parent = classBasedTestDescriptor.getParent().orElse(null);
            if (parent instanceof ClassBasedTestDescriptor) {
                ClassBasedTestDescriptor parentClassTestDescriptor = parent;
                AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> cacheEntry = (AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor>)this.ordererCache.get((Object)parentClassTestDescriptor);
                return cacheEntry != null ? cacheEntry : this.createClassLevelOrderer(parentClassTestDescriptor);
            }
            return this.globalOrderer;
        });
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> createDescriptorWrapperOrderer(ClassOrderer classOrderer) {
        Consumer orderingAction = classDescriptors -> classOrderer.orderClasses((ClassOrdererContext)new DefaultClassOrdererContext((List<? extends ClassDescriptor>)classDescriptors, this.configuration));
        AbstractOrderingVisitor.MessageGenerator descriptorsAddedMessageGenerator = number -> "ClassOrderer [%s] added %s ClassDescriptor(s) which will be ignored.".formatted(classOrderer.getClass().getName(), number);
        AbstractOrderingVisitor.MessageGenerator descriptorsRemovedMessageGenerator = number -> "ClassOrderer [%s] removed %s ClassDescriptor(s) which will be retained with arbitrary ordering.".formatted(classOrderer.getClass().getName(), number);
        return new AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor>(classOrderer, orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
    }

    private Optional<Consumer<ClassBasedTestDescriptor>> toValidationAction(AbstractOrderingVisitor.DescriptorWrapperOrderer<ClassOrderer, DefaultClassDescriptor> wrapperOrderer) {
        if (wrapperOrderer.getOrderer() instanceof ClassOrderer.OrderAnnotation) {
            return Optional.empty();
        }
        return Optional.of(arg_0 -> this.noOrderAnnotation.check(arg_0));
    }
}

