/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTemplateTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestClassAware;
import org.junit.jupiter.engine.discovery.predicates.TestClassPredicates;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class ClassSelectorResolver
implements SelectorResolver {
    private final Predicate<String> classNameFilter;
    private final JupiterConfiguration configuration;
    private final TestClassPredicates predicates;
    private final DiscoveryIssueReporter issueReporter;

    ClassSelectorResolver(Predicate<String> classNameFilter, JupiterConfiguration configuration, DiscoveryIssueReporter issueReporter) {
        this.classNameFilter = classNameFilter;
        this.configuration = configuration;
        this.predicates = new TestClassPredicates(issueReporter);
        this.issueReporter = issueReporter;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        Class testClass = selector.getJavaClass();
        if (this.predicates.isAnnotatedWithNested.test(testClass)) {
            if (this.predicates.isValidNestedTestClass(testClass)) {
                return this.toResolution(context.addToParent(() -> DiscoverySelectors.selectClass(testClass.getEnclosingClass()), parent -> Optional.of(this.newMemberClassTestDescriptor((TestDescriptor)parent, testClass))));
            }
        } else if (this.isAcceptedStandaloneTestClass(testClass)) {
            return this.toResolution(context.addToParent(parent -> Optional.of(this.newStandaloneClassTestDescriptor((TestDescriptor)parent, testClass))));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private boolean isAcceptedStandaloneTestClass(Class<?> testClass) {
        return this.classNameFilter.test(testClass.getName()) && this.predicates.looksLikeIntendedTestClass(testClass) && this.predicates.isValidStandaloneTestClass(testClass);
    }

    public SelectorResolver.Resolution resolve(NestedClassSelector selector, SelectorResolver.Context context) {
        Class nestedClass = selector.getNestedClass();
        if (this.predicates.isAnnotatedWithNested.test(nestedClass)) {
            if (this.predicates.isValidNestedTestClass(nestedClass)) {
                return this.toResolution(context.addToParent(() -> this.selectClass(selector.getEnclosingClasses()), parent -> Optional.of(this.newMemberClassTestDescriptor((TestDescriptor)parent, nestedClass))));
            }
        } else if (ReflectionUtils.isInnerClass((Class)nestedClass) && ReflectionUtils.isNotAbstract((Class)nestedClass) && this.predicates.looksLikeIntendedTestClass(nestedClass)) {
            String message = "Inner class '%s' looks like it was intended to be a test class but will not be executed. It must be static or annotated with @Nested.".formatted(nestedClass.getName());
            this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)ClassSource.from((Class)nestedClass)));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId.Segment lastSegment = uniqueId.getLastSegment();
        return switch (lastSegment.getType()) {
            case "class" -> this.resolveStandaloneClassUniqueId(context, lastSegment, __ -> true, this::newClassTestDescriptor);
            case "class-template" -> this.resolveStandaloneClassUniqueId(context, lastSegment, this.predicates.isAnnotatedWithClassTemplate, this::newClassTemplateTestDescriptor);
            case "nested-class" -> this.resolveNestedClassUniqueId(context, uniqueId, __ -> true, this::newNestedClassTestDescriptor);
            case "nested-class-template" -> this.resolveNestedClassUniqueId(context, uniqueId, this.predicates.isAnnotatedWithClassTemplate, this::newNestedClassTemplateTestDescriptor);
            case "class-template-invocation" -> {
                Optional testDescriptor = context.addToParent(() -> DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), parent -> {
                    int index = Integer.parseInt(lastSegment.getValue().substring(1));
                    return Optional.of(this.newDummyClassTemplateInvocationTestDescriptor((TestDescriptor)parent, index));
                });
                yield this.toInvocationMatch(testDescriptor).map(SelectorResolver.Resolution::match).orElse(SelectorResolver.Resolution.unresolved());
            }
            default -> SelectorResolver.Resolution.unresolved();
        };
    }

    public SelectorResolver.Resolution resolve(IterationSelector selector, SelectorResolver.Context context) {
        NestedClassSelector nestedClassSelector;
        ClassSelector classSelector;
        DiscoverySelector parentSelector = selector.getParentSelector();
        if (parentSelector instanceof ClassSelector && this.predicates.isAnnotatedWithClassTemplate.test((classSelector = (ClassSelector)parentSelector).getJavaClass())) {
            return this.resolveIterations(selector, context);
        }
        if (parentSelector instanceof NestedClassSelector && this.predicates.isAnnotatedWithClassTemplate.test((nestedClassSelector = (NestedClassSelector)parentSelector).getNestedClass())) {
            return this.resolveIterations(selector, context);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution resolveIterations(IterationSelector selector, SelectorResolver.Context context) {
        DiscoverySelector parentSelector = selector.getParentSelector();
        Set matches = selector.getIterationIndices().stream().map(index -> context.addToParent(() -> parentSelector, parent -> Optional.of(this.newDummyClassTemplateInvocationTestDescriptor((TestDescriptor)parent, index + 1)))).map(this::toInvocationMatch).flatMap(Optional::stream).collect(Collectors.toSet());
        return matches.isEmpty() ? SelectorResolver.Resolution.unresolved() : SelectorResolver.Resolution.matches(matches);
    }

    private SelectorResolver.Resolution resolveStandaloneClassUniqueId(SelectorResolver.Context context, UniqueId.Segment lastSegment, Predicate<? super Class<?>> condition, BiFunction<TestDescriptor, Class<?>, ClassBasedTestDescriptor> factory) {
        String className = lastSegment.getValue();
        return ReflectionSupport.tryToLoadClass((String)className).toOptional().filter(this.predicates::isValidStandaloneTestClass).filter(condition).map(testClass -> this.toResolution(context.addToParent(parent -> Optional.of((ClassBasedTestDescriptor)factory.apply((TestDescriptor)parent, (Class<?>)testClass))))).orElse(SelectorResolver.Resolution.unresolved());
    }

    private SelectorResolver.Resolution resolveNestedClassUniqueId(SelectorResolver.Context context, UniqueId uniqueId, Predicate<? super Class<?>> condition, BiFunction<TestDescriptor, Class<?>, ClassBasedTestDescriptor> factory) {
        String simpleClassName = uniqueId.getLastSegment().getValue();
        return this.toResolution(context.addToParent(() -> DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), parent -> {
            Class<?> parentTestClass = ((TestClassAware)parent).getTestClass();
            return ReflectionSupport.findNestedClasses(parentTestClass, this.predicates.isAnnotatedWithNestedAndValid.and(FunctionUtils.where(Class::getSimpleName, Predicate.isEqual(simpleClassName)))).stream().findFirst().filter(condition).map(testClass -> (ClassBasedTestDescriptor)factory.apply((TestDescriptor)parent, (Class<?>)testClass));
        }));
    }

    private ClassTemplateInvocationTestDescriptor newDummyClassTemplateInvocationTestDescriptor(TestDescriptor parent, int index) {
        UniqueId uniqueId = parent.getUniqueId().append("class-template-invocation", "#" + index);
        return new ClassTemplateInvocationTestDescriptor(uniqueId, (ClassTemplateTestDescriptor)parent, DummyClassTemplateInvocationContext.INSTANCE, index, parent.getSource().orElse(null), this.configuration);
    }

    private ClassBasedTestDescriptor newStandaloneClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return this.predicates.isAnnotatedWithClassTemplate.test(testClass) ? this.newClassTemplateTestDescriptor(parent, testClass) : this.newClassTestDescriptor(parent, testClass);
    }

    private ClassTemplateTestDescriptor newClassTemplateTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return this.newClassTemplateTestDescriptor(parent, "class-template", this.newClassTestDescriptor(parent, testClass));
    }

    private ClassTestDescriptor newClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return new ClassTestDescriptor(parent.getUniqueId().append("class", testClass.getName()), testClass, this.configuration);
    }

    private ClassBasedTestDescriptor newMemberClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return this.predicates.isAnnotatedWithClassTemplate.test(testClass) ? this.newNestedClassTemplateTestDescriptor(parent, testClass) : this.newNestedClassTestDescriptor(parent, testClass);
    }

    private ClassTemplateTestDescriptor newNestedClassTemplateTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        return this.newClassTemplateTestDescriptor(parent, "nested-class-template", this.newNestedClassTestDescriptor(parent, testClass));
    }

    private NestedClassTestDescriptor newNestedClassTestDescriptor(TestDescriptor parent, Class<?> testClass) {
        UniqueId uniqueId = parent.getUniqueId().append("nested-class", testClass.getSimpleName());
        return new NestedClassTestDescriptor(uniqueId, testClass, () -> NestedClassTestDescriptor.getEnclosingTestClasses(parent), this.configuration);
    }

    private ClassTemplateTestDescriptor newClassTemplateTestDescriptor(TestDescriptor parent, String segmentType, ClassBasedTestDescriptor delegate) {
        delegate.setParent(parent);
        String segmentValue = delegate.getUniqueId().getLastSegment().getValue();
        UniqueId uniqueId = parent.getUniqueId().append(segmentType, segmentValue);
        return new ClassTemplateTestDescriptor(uniqueId, delegate);
    }

    private Optional<SelectorResolver.Match> toInvocationMatch(Optional<ClassTemplateInvocationTestDescriptor> testDescriptor) {
        return testDescriptor.map(it -> SelectorResolver.Match.exact((TestDescriptor)it, this.expansionCallback((TestDescriptor)it, () -> it.getParent().map(parent -> ClassSelectorResolver.getTestClasses((TestClassAware)parent)).orElse(Collections.emptyList()))));
    }

    private SelectorResolver.Resolution toResolution(Optional<? extends ClassBasedTestDescriptor> testDescriptor) {
        return testDescriptor.map(it -> SelectorResolver.Resolution.match((SelectorResolver.Match)SelectorResolver.Match.exact((TestDescriptor)it, this.expansionCallback((ClassBasedTestDescriptor)it)))).orElse(SelectorResolver.Resolution.unresolved());
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(ClassBasedTestDescriptor testDescriptor) {
        return this.expansionCallback(testDescriptor, () -> ClassSelectorResolver.getTestClasses(testDescriptor));
    }

    private static List<Class<?>> getTestClasses(TestClassAware testDescriptor) {
        ArrayList testClasses = new ArrayList(testDescriptor.getEnclosingTestClasses());
        testClasses.add(testDescriptor.getTestClass());
        return testClasses;
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(TestDescriptor testDescriptor, Supplier<List<Class<?>>> testClassesSupplier) {
        return () -> {
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)testDescriptor;
                filterable.getDynamicDescendantFilter().allowAll();
            }
            List testClasses = (List)testClassesSupplier.get();
            Class testClass = (Class)testClasses.get(testClasses.size() - 1);
            Stream<DiscoverySelector> methods = ReflectionSupport.findMethods((Class)testClass, this.predicates.isTestOrTestFactoryOrTestTemplateMethod, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).stream().map(method -> this.selectMethod(testClasses, (Method)method));
            Stream annotatedNestedClasses = ReflectionUtils.streamNestedClasses((Class)testClass, this.predicates.isAnnotatedWithNested);
            Stream notAnnotatedInnerClasses = ReflectionUtils.streamNestedClasses((Class)testClass, this.predicates.isAnnotatedWithNested.negate().and(ReflectionUtils::isInnerClass), (ReflectionUtils.CycleErrorHandling)ReflectionUtils.CycleErrorHandling.ABORT_VISIT);
            Stream<NestedClassSelector> nestedClasses = Stream.concat(annotatedNestedClasses, notAnnotatedInnerClasses).map(nestedClass -> DiscoverySelectors.selectNestedClass((List)testClasses, (Class)nestedClass));
            return Stream.concat(methods, nestedClasses).collect(Collectors.toCollection(LinkedHashSet::new));
        };
    }

    private DiscoverySelector selectClass(List<Class<?>> classes) {
        if (classes.size() == 1) {
            return DiscoverySelectors.selectClass(classes.get(0));
        }
        int lastIndex = classes.size() - 1;
        return DiscoverySelectors.selectNestedClass(classes.subList(0, lastIndex), classes.get(lastIndex));
    }

    private DiscoverySelector selectMethod(List<Class<?>> classes, Method method) {
        if (classes.size() == 1) {
            return DiscoverySelectors.selectMethod(classes.get(0), (Method)method);
        }
        int lastIndex = classes.size() - 1;
        return DiscoverySelectors.selectNestedMethod(classes.subList(0, lastIndex), classes.get(lastIndex), (Method)method);
    }

    static class DummyClassTemplateInvocationContext
    implements ClassTemplateInvocationContext {
        private static final DummyClassTemplateInvocationContext INSTANCE = new DummyClassTemplateInvocationContext();

        DummyClassTemplateInvocationContext() {
        }
    }
}

