/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;

@API(status=API.Status.INTERNAL, since="5.0")
public class NamespaceAwareStore
implements ExtensionContext.Store {
    private final NamespacedHierarchicalStore<Namespace> valuesStore;
    private final Namespace namespace;

    public NamespaceAwareStore(NamespacedHierarchicalStore<Namespace> valuesStore, Namespace namespace) {
        this.valuesStore = valuesStore;
        this.namespace = namespace;
    }

    public @Nullable Object get(Object key) {
        Preconditions.notNull((Object)key, (String)"key must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.get((Object)this.namespace, key);
        return this.accessStore(action);
    }

    public <T> @Nullable T get(Object key, Class<T> requiredType) {
        Preconditions.notNull((Object)key, (String)"key must not be null");
        Preconditions.notNull(requiredType, (String)"requiredType must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.get((Object)this.namespace, key, requiredType);
        return (T)this.accessStore(action);
    }

    public <K, V> @Nullable Object getOrComputeIfAbsent(K key, Function<? super K, ? extends V> defaultCreator) {
        Preconditions.notNull(key, (String)"key must not be null");
        Preconditions.notNull(defaultCreator, (String)"defaultCreator function must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.getOrComputeIfAbsent((Object)this.namespace, key, defaultCreator);
        return this.accessStore(action);
    }

    public <K, V> @Nullable V getOrComputeIfAbsent(K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) {
        Preconditions.notNull(key, (String)"key must not be null");
        Preconditions.notNull(defaultCreator, (String)"defaultCreator function must not be null");
        Preconditions.notNull(requiredType, (String)"requiredType must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.getOrComputeIfAbsent((Object)this.namespace, key, defaultCreator, requiredType);
        return (V)this.accessStore(action);
    }

    public void put(Object key, @Nullable Object value) {
        Preconditions.notNull((Object)key, (String)"key must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.put((Object)this.namespace, key, value);
        this.accessStore(action);
    }

    public @Nullable Object remove(Object key) {
        Preconditions.notNull((Object)key, (String)"key must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.remove((Object)this.namespace, key);
        return this.accessStore(action);
    }

    public <T> @Nullable T remove(Object key, Class<T> requiredType) {
        Preconditions.notNull((Object)key, (String)"key must not be null");
        Preconditions.notNull(requiredType, (String)"requiredType must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.remove((Object)this.namespace, key, requiredType);
        return (T)this.accessStore(action);
    }

    private <T> @Nullable T accessStore(Supplier<@Nullable T> action) {
        try {
            return action.get();
        }
        catch (NamespacedHierarchicalStoreException e) {
            throw new ExtensionContextException(e.getMessage(), (Throwable)e);
        }
    }
}

