/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.scanning.ClasspathScanner;
import org.junit.platform.commons.support.scanning.DefaultClasspathScanner;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class ClasspathScannerLoader {
    ClasspathScannerLoader() {
    }

    static ClasspathScanner getInstance() {
        ServiceLoader<ClasspathScanner> serviceLoader = ServiceLoader.load(ClasspathScanner.class, ClassLoaderUtils.getDefaultClassLoader());
        List classpathScanners = StreamSupport.stream(serviceLoader.spliterator(), false).toList();
        if (classpathScanners.size() == 1) {
            return (ClasspathScanner)classpathScanners.get(0);
        }
        if (classpathScanners.size() > 1) {
            throw new JUnitException("There should not be more than one ClasspathScanner implementation present on the classpath but there were %d: %s".formatted(classpathScanners.size(), classpathScanners));
        }
        return new DefaultClasspathScanner(ClassLoaderUtils::getDefaultClassLoader, ReflectionUtils::tryToLoadClass);
    }
}

