/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T notNull(@Nullable T object, String message) throws PreconditionViolationException {
        if (object == null) {
            throw new PreconditionViolationException(message);
        }
        return object;
    }

    public static <T> T notNull(@Nullable T object, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (object == null) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
        return object;
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static int[] notEmpty(int @Nullable [] array, String message) throws PreconditionViolationException {
        if (array == null || array.length == 0) {
            throw new PreconditionViolationException(message);
        }
        return array;
    }

    public static <T> T[] notEmpty(T @Nullable [] array, String message) throws PreconditionViolationException {
        if (array == null || array.length == 0) {
            throw new PreconditionViolationException(message);
        }
        return array;
    }

    public static <T> T[] notEmpty(T @Nullable [] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (array == null || array.length == 0) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(@Nullable T collection, String message) throws PreconditionViolationException {
        if (collection == null || collection.isEmpty()) {
            throw new PreconditionViolationException(message);
        }
        return collection;
    }

    public static <T extends Collection<?>> T notEmpty(@Nullable T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (collection == null || collection.isEmpty()) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
        return collection;
    }

    public static <T> T @Nullable [] containsNoNullElements(T @Nullable [] array, String message) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, message));
        }
        return array;
    }

    public static <T> T @Nullable [] containsNoNullElements(T @Nullable [] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return array;
    }

    public static <T extends Collection<?>> @Nullable T containsNoNullElements(@Nullable T collection, String message) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, message));
        }
        return (T)collection;
    }

    public static <T extends Collection<?>> @Nullable T containsNoNullElements(@Nullable T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return (T)collection;
    }

    public static String notBlank(@Nullable String str, String message) throws PreconditionViolationException {
        if (str == null || StringUtils.isBlank(str)) {
            throw new PreconditionViolationException(message);
        }
        return str;
    }

    public static String notBlank(@Nullable String str, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (str == null || StringUtils.isBlank(str)) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
        return str;
    }

    public static void condition(boolean predicate, String message) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(message);
        }
    }

    public static void condition(boolean predicate, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
    }
}

