/*
 * Copyright 2015-2026 the original author or authors.
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v2.0 which
 * accompanies this distribution and is available at
 *
 * https://www.eclipse.org/legal/epl-v20.html
 */


/**
 * Common support APIs provided by the JUnit Platform.
 *
 * <p>The purpose of this package is to provide {@code TestEngine} and
 * {@code Extension} authors convenient access to a subset of internal utility
 * methods to assist with their implementation. This prevents re-inventing the
 * wheel and ensures that common tasks are handled in third-party engines and
 * extensions with the same semantics as within the JUnit Platform itself.
 */

@NullMarked
package org.junit.platform.commons.support;

import org.jspecify.annotations.NullMarked;
