/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.LockManager;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.NodeExecutionAdvisor;
import org.junit.platform.engine.support.hierarchical.NodeUtils;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

class NodeTreeWalker {
    private final LockManager lockManager;
    private final ResourceLock globalReadLock;
    private final ResourceLock globalReadWriteLock;

    NodeTreeWalker() {
        this(new LockManager());
    }

    NodeTreeWalker(LockManager lockManager) {
        this.lockManager = lockManager;
        this.globalReadLock = lockManager.getLockForResource(ExclusiveResource.GLOBAL_READ);
        this.globalReadWriteLock = lockManager.getLockForResource(ExclusiveResource.GLOBAL_READ_WRITE);
    }

    NodeExecutionAdvisor walk(TestDescriptor rootDescriptor) {
        Preconditions.condition((boolean)this.getExclusiveResources(rootDescriptor).isEmpty(), (String)"Engine descriptor must not declare exclusive resources");
        NodeExecutionAdvisor advisor = new NodeExecutionAdvisor();
        rootDescriptor.getChildren().forEach(child -> this.walk((TestDescriptor)child, (TestDescriptor)child, advisor));
        return advisor;
    }

    private void walk(TestDescriptor globalLockDescriptor, TestDescriptor testDescriptor, NodeExecutionAdvisor advisor) {
        Set<ExclusiveResource> exclusiveResources = this.getExclusiveResources(testDescriptor);
        if (exclusiveResources.isEmpty()) {
            if (globalLockDescriptor.equals(testDescriptor)) {
                advisor.useResourceLock(globalLockDescriptor, this.globalReadLock);
            }
            testDescriptor.getChildren().forEach(child -> this.walk(globalLockDescriptor, (TestDescriptor)child, advisor));
        } else {
            HashSet<ExclusiveResource> allResources = new HashSet<ExclusiveResource>(exclusiveResources);
            if (this.isReadOnly(allResources)) {
                this.doForChildrenRecursively(testDescriptor, child -> allResources.addAll(this.getExclusiveResources((TestDescriptor)child)));
                if (!this.isReadOnly(allResources)) {
                    this.forceDescendantExecutionModeRecursively(advisor, testDescriptor);
                }
            } else {
                advisor.forceDescendantExecutionMode(testDescriptor, Node.ExecutionMode.SAME_THREAD);
                this.doForChildrenRecursively(testDescriptor, child -> {
                    allResources.addAll(this.getExclusiveResources((TestDescriptor)child));
                    advisor.forceDescendantExecutionMode((TestDescriptor)child, Node.ExecutionMode.SAME_THREAD);
                });
            }
            if (allResources.contains(ExclusiveResource.GLOBAL_READ_WRITE)) {
                this.forceDescendantExecutionModeRecursively(advisor, globalLockDescriptor);
                advisor.useResourceLock(globalLockDescriptor, this.globalReadWriteLock);
            } else {
                if (globalLockDescriptor.equals(testDescriptor)) {
                    allResources.add(ExclusiveResource.GLOBAL_READ);
                } else {
                    allResources.remove(ExclusiveResource.GLOBAL_READ);
                }
                advisor.useResourceLock(testDescriptor, this.lockManager.getLockForResources(allResources));
            }
        }
    }

    private void forceDescendantExecutionModeRecursively(NodeExecutionAdvisor advisor, TestDescriptor testDescriptor) {
        advisor.forceDescendantExecutionMode(testDescriptor, Node.ExecutionMode.SAME_THREAD);
        this.doForChildrenRecursively(testDescriptor, child -> advisor.forceDescendantExecutionMode((TestDescriptor)child, Node.ExecutionMode.SAME_THREAD));
    }

    private boolean isReadOnly(Set<ExclusiveResource> exclusiveResources) {
        return exclusiveResources.stream().allMatch(exclusiveResource -> exclusiveResource.getLockMode() == ExclusiveResource.LockMode.READ);
    }

    private Set<ExclusiveResource> getExclusiveResources(TestDescriptor testDescriptor) {
        return NodeUtils.asNode(testDescriptor).getExclusiveResources();
    }

    private void doForChildrenRecursively(TestDescriptor parent, Consumer<TestDescriptor> consumer) {
        parent.getChildren().forEach(child -> {
            consumer.accept((TestDescriptor)child);
            this.doForChildrenRecursively((TestDescriptor)child, consumer);
        });
    }
}

