/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

@API(status=API.Status.STABLE, since="1.0")
public class ExecutionRequest {
    private final TestDescriptor rootTestDescriptor;
    private final EngineExecutionListener engineExecutionListener;
    private final ConfigurationParameters configurationParameters;
    private final @Nullable OutputDirectoryProvider outputDirectoryProvider;
    private final @Nullable NamespacedHierarchicalStore<Namespace> requestLevelStore;

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.11")
    public ExecutionRequest(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters) {
        this(rootTestDescriptor, engineExecutionListener, configurationParameters, null, null);
    }

    private ExecutionRequest(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters, @Nullable OutputDirectoryProvider outputDirectoryProvider, @Nullable NamespacedHierarchicalStore<Namespace> requestLevelStore) {
        this.rootTestDescriptor = (TestDescriptor)Preconditions.notNull((Object)rootTestDescriptor, (String)"rootTestDescriptor must not be null");
        this.engineExecutionListener = (EngineExecutionListener)Preconditions.notNull((Object)engineExecutionListener, (String)"engineExecutionListener must not be null");
        this.configurationParameters = (ConfigurationParameters)Preconditions.notNull((Object)configurationParameters, (String)"configurationParameters must not be null");
        this.outputDirectoryProvider = outputDirectoryProvider;
        this.requestLevelStore = requestLevelStore;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.11")
    public static ExecutionRequest create(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters) {
        return new ExecutionRequest(rootTestDescriptor, engineExecutionListener, configurationParameters);
    }

    @API(status=API.Status.INTERNAL, since="1.13")
    public static ExecutionRequest create(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider, NamespacedHierarchicalStore<Namespace> requestLevelStore) {
        return new ExecutionRequest(rootTestDescriptor, engineExecutionListener, configurationParameters, (OutputDirectoryProvider)Preconditions.notNull((Object)outputDirectoryProvider, (String)"outputDirectoryProvider must not be null"), (NamespacedHierarchicalStore)Preconditions.notNull(requestLevelStore, (String)"requestLevelStore must not be null"));
    }

    public TestDescriptor getRootTestDescriptor() {
        return this.rootTestDescriptor;
    }

    public EngineExecutionListener getEngineExecutionListener() {
        return this.engineExecutionListener;
    }

    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public OutputDirectoryProvider getOutputDirectoryProvider() {
        return (OutputDirectoryProvider)Preconditions.notNull((Object)this.outputDirectoryProvider, (String)"No OutputDirectoryProvider was configured for this request");
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public NamespacedHierarchicalStore<Namespace> getStore() {
        return (NamespacedHierarchicalStore)Preconditions.notNull(this.requestLevelStore, (String)"No NamespacedHierarchicalStore was configured for this request");
    }
}

