/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public class DirectorySelector
implements DiscoverySelector {
    private final String path;

    DirectorySelector(String path) {
        this.path = path;
    }

    public File getDirectory() {
        return new File(this.path);
    }

    public Path getPath() {
        return Path.of(this.path, new String[0]);
    }

    public String getRawPath() {
        return this.path;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectorySelector that = (DirectorySelector)o;
        return Objects.equals(this.path, that.path);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("path", (Object)this.path).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return Optional.of(DiscoverySelectorIdentifier.create("directory", this.path));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "directory";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<DirectorySelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectDirectory(identifier.getValue()));
        }
    }
}

