/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;

@API(status=API.Status.STABLE, since="1.6")
public class NestedMethodSelector
implements DiscoverySelector {
    private final NestedClassSelector nestedClassSelector;
    private final MethodSelector methodSelector;

    NestedMethodSelector(@Nullable ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName, String methodName, String parameterTypeNames) {
        this.nestedClassSelector = new NestedClassSelector(classLoader, enclosingClassNames, nestedClassName);
        this.methodSelector = new MethodSelector(classLoader, nestedClassName, methodName, parameterTypeNames);
    }

    NestedMethodSelector(@Nullable ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName, String methodName, Class<?> ... parameterTypes) {
        this.nestedClassSelector = new NestedClassSelector(classLoader, enclosingClassNames, nestedClassName);
        this.methodSelector = new MethodSelector(classLoader, nestedClassName, methodName, parameterTypes);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, String parameterTypeNames) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, methodName, parameterTypeNames);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, Class<?> ... parameterTypes) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, methodName, parameterTypes);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, Method method) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, method);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public @Nullable ClassLoader getClassLoader() {
        return this.nestedClassSelector.getClassLoader();
    }

    public List<String> getEnclosingClassNames() {
        return this.nestedClassSelector.getEnclosingClassNames();
    }

    public List<Class<?>> getEnclosingClasses() {
        return this.nestedClassSelector.getEnclosingClasses();
    }

    public String getNestedClassName() {
        return this.nestedClassSelector.getNestedClassName();
    }

    public Class<?> getNestedClass() {
        return this.nestedClassSelector.getNestedClass();
    }

    public String getMethodName() {
        return this.methodSelector.getMethodName();
    }

    public Method getMethod() {
        return this.methodSelector.getJavaMethod();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public String getParameterTypeNames() {
        return this.methodSelector.getParameterTypeNames();
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public Class<?>[] getParameterTypes() {
        return this.methodSelector.getParameterTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedMethodSelector that = (NestedMethodSelector)o;
        return this.nestedClassSelector.equals(that.nestedClassSelector) && this.methodSelector.equals(that.methodSelector);
    }

    public int hashCode() {
        return Objects.hash(this.nestedClassSelector, this.methodSelector);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("enclosingClassNames", this.getEnclosingClassNames()).append("nestedClassName", (Object)this.getNestedClassName()).append("methodName", (Object)this.getMethodName()).append("parameterTypes", (Object)this.getParameterTypeNames()).append("classLoader", (Object)this.getClassLoader()).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return this.nestedClassSelector.toIdentifier().map(parent -> {
            String fullyQualifiedMethodName = ReflectionUtils.getFullyQualifiedMethodName((String)parent.getValue(), (String)this.methodSelector.getMethodName(), (String)this.methodSelector.getParameterTypeNames());
            return DiscoverySelectorIdentifier.create("nested-method", fullyQualifiedMethodName);
        });
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "nested-method";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<NestedMethodSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            List<String> parts = Arrays.asList(identifier.getValue().split("/"));
            List<String> enclosingClassNames = parts.subList(0, parts.size() - 1);
            String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)parts.get(parts.size() - 1));
            String nestedClassName = methodParts[0];
            String methodName = methodParts[1];
            String parameterTypeNames = methodParts[2];
            return Optional.of(DiscoverySelectors.selectNestedMethod(enclosingClassNames, nestedClassName, methodName, parameterTypeNames));
        }
    }
}

