/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ServiceLoader;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.core.TestEngineFormatter;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"org.junit.platform.suite.engine"})
public final class ServiceLoaderTestEngineRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoaderTestEngineRegistry.class);

    public Iterable<TestEngine> loadTestEngines() {
        ServiceLoader<TestEngine> testEngines = ServiceLoader.load(TestEngine.class, ClassLoaderUtils.getDefaultClassLoader());
        logger.config(() -> TestEngineFormatter.format("Discovered TestEngines", testEngines));
        return testEngines;
    }
}

