/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.data.Index;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.testkit.engine.Event;
import org.junit.platform.testkit.engine.EventStatistics;
import org.junit.platform.testkit.engine.EventType;
import org.junit.platform.testkit.engine.Executions;
import org.opentest4j.AssertionFailedError;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class Events {
    private final List<Event> events;
    private final String category;

    Events(Stream<Event> events, String category) {
        this(((Stream)Preconditions.notNull(events, (String)"Event stream must not be null")).collect(Collectors.toList()), category);
    }

    Events(List<Event> events, String category) {
        Preconditions.notNull(events, (String)"Event list must not be null");
        Preconditions.containsNoNullElements(events, (String)"Event list must not contain null elements");
        this.events = Collections.unmodifiableList(events);
        this.category = category;
    }

    String getCategory() {
        return this.category;
    }

    public List<Event> list() {
        return this.events;
    }

    public Stream<Event> stream() {
        return this.events.stream();
    }

    public <R> Stream<R> map(Function<? super Event, ? extends R> mapper) {
        Preconditions.notNull(mapper, (String)"Mapping function must not be null");
        return this.stream().map(mapper);
    }

    public Stream<Event> filter(Predicate<? super Event> predicate) {
        Preconditions.notNull(predicate, (String)"Filter predicate must not be null");
        return this.stream().filter(predicate);
    }

    public Executions executions() {
        return new Executions(this.events, this.category);
    }

    public long count() {
        return this.events.size();
    }

    public Events skipped() {
        return new Events(this.eventsByType(EventType.SKIPPED), this.category + " Skipped");
    }

    public Events started() {
        return new Events(this.eventsByType(EventType.STARTED), this.category + " Started");
    }

    public Events finished() {
        return new Events(this.eventsByType(EventType.FINISHED), this.category + " Finished");
    }

    public Events aborted() {
        return new Events(this.finishedEventsByStatus(TestExecutionResult.Status.ABORTED), this.category + " Aborted");
    }

    public Events succeeded() {
        return new Events(this.finishedEventsByStatus(TestExecutionResult.Status.SUCCESSFUL), this.category + " Successful");
    }

    public Events failed() {
        return new Events(this.finishedEventsByStatus(TestExecutionResult.Status.FAILED), this.category + " Failed");
    }

    public Events reportingEntryPublished() {
        return new Events(this.eventsByType(EventType.REPORTING_ENTRY_PUBLISHED), this.category + " Reporting Entry Published");
    }

    public Events dynamicallyRegistered() {
        return new Events(this.eventsByType(EventType.DYNAMIC_TEST_REGISTERED), this.category + " Dynamically Registered");
    }

    public Events assertStatistics(Consumer<EventStatistics> statisticsConsumer) {
        Preconditions.notNull(statisticsConsumer, (String)"Consumer must not be null");
        EventStatistics eventStatistics = new EventStatistics(this, this.category);
        statisticsConsumer.accept(eventStatistics);
        eventStatistics.assertAll();
        return this;
    }

    @SafeVarargs
    public final void assertEventsMatchExactly(Condition<? super Event> ... conditions) {
        Preconditions.notNull(conditions, (String)"conditions must not be null");
        Events.assertEventsMatchExactly(this.events, conditions);
    }

    @SafeVarargs
    public final void assertEventsMatchLoosely(Condition<? super Event> ... conditions) {
        Preconditions.notNull(conditions, (String)"conditions must not be null");
        Preconditions.containsNoNullElements((Object[])conditions, (String)"conditions must not contain null elements");
        Events.assertEventsMatchLoosely(this.events, conditions);
    }

    @SafeVarargs
    public final void assertEventsMatchLooselyInOrder(Condition<? super Event> ... conditions) {
        Preconditions.notNull(conditions, (String)"conditions must not be null");
        Preconditions.containsNoNullElements((Object[])conditions, (String)"conditions must not contain null elements");
        Events.assertEventsMatchLooselyInOrder(this.events, conditions);
    }

    public ListAssert<Event> assertThatEvents() {
        return Assertions.assertThat(this.list());
    }

    public Events debug() {
        this.debug(System.out);
        return this;
    }

    public Events debug(OutputStream out) {
        Preconditions.notNull((Object)out, (String)"OutputStream must not be null");
        this.debug(new PrintWriter(out, true));
        return this;
    }

    public Events debug(Writer writer) {
        Preconditions.notNull((Object)writer, (String)"Writer must not be null");
        this.debug(new PrintWriter(writer, true));
        return this;
    }

    private Events debug(PrintWriter printWriter) {
        printWriter.println(this.category + " Events:");
        this.events.forEach(event -> printWriter.printf("\t%s%n", event));
        return this;
    }

    private Stream<Event> eventsByType(EventType type) {
        Preconditions.notNull((Object)((Object)type), (String)"EventType must not be null");
        return this.stream().filter(Event.byType(type));
    }

    private Stream<Event> finishedEventsByStatus(TestExecutionResult.Status status) {
        Preconditions.notNull((Object)status, (String)"Status must not be null");
        return this.eventsByType(EventType.FINISHED).filter(Event.byPayload(TestExecutionResult.class, FunctionUtils.where(TestExecutionResult::getStatus, Predicate.isEqual(status))));
    }

    @SafeVarargs
    private static void assertEventsMatchExactly(List<Event> events, Condition<? super Event> ... conditions) {
        Assertions.assertThat(events).hasSize(conditions.length);
        SoftAssertions softly = new SoftAssertions();
        for (int i = 0; i < conditions.length; ++i) {
            softly.assertThat(events).has(conditions[i], Index.atIndex((int)i));
        }
        softly.assertAll();
    }

    @SafeVarargs
    private static void assertEventsMatchLoosely(List<Event> events, Condition<? super Event> ... conditions) {
        SoftAssertions softly = new SoftAssertions();
        for (Condition<? super Event> condition : conditions) {
            Events.checkCondition(events, softly, condition);
        }
        softly.assertAll();
    }

    @SafeVarargs
    private static void assertEventsMatchLooselyInOrder(List<Event> events, Condition<? super Event> ... conditions) {
        Assertions.assertThat((Object[])conditions).hasSizeLessThanOrEqualTo(events.size());
        SoftAssertions softly = new SoftAssertions();
        List<Integer> indices = Arrays.stream(conditions).map((? super T condition) -> Events.findEvent(events, softly, (Condition<? super Event>)condition)).filter(Objects::nonNull).map(events::indexOf).collect(Collectors.toList());
        if (Events.isNotInIncreasingOrder(indices)) {
            throw new AssertionFailedError("Conditions are not in the correct order.");
        }
        softly.assertAll();
    }

    private static boolean isNotInIncreasingOrder(List<Integer> indices) {
        ArrayList<Integer> copy = new ArrayList<Integer>(indices);
        Collections.sort(copy);
        return !indices.equals(copy);
    }

    private static void checkCondition(List<Event> events, SoftAssertions softly, Condition<? super Event> condition) {
        if (events.stream().noneMatch(arg_0 -> condition.matches(arg_0))) {
            softly.fail("Condition did not match any event: " + condition);
        }
    }

    private static Event findEvent(List<Event> events, SoftAssertions softly, Condition<? super Event> condition) {
        Optional<Event> matchedEvent = events.stream().filter(arg_0 -> condition.matches(arg_0)).findFirst();
        if (!matchedEvent.isPresent()) {
            softly.fail("Condition did not match any event: " + condition);
        }
        return matchedEvent.orElse(null);
    }
}

