/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.item;

import java.util.Arrays;
import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.Item;

public class PlaylistItem
extends Item {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.playlistItem");

    public PlaylistItem() {
        this.setClazz(CLASS);
    }

    public PlaylistItem(Item other) {
        super(other);
    }

    public PlaylistItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public PlaylistItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.getResources().addAll(Arrays.asList(resource));
        }
    }

    public PersonWithRole getFirstArtist() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ARTIST.class);
    }

    public PersonWithRole[] getArtists() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ARTIST.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public PlaylistItem setArtists(PersonWithRole[] artists) {
        this.removeProperties(DIDLObject.Property.UPNP.ARTIST.class);
        PersonWithRole[] personWithRoleArray = artists;
        int n = artists.length;
        int n2 = 0;
        while (n2 < n) {
            PersonWithRole artist = personWithRoleArray[n2];
            this.addProperty(new DIDLObject.Property.UPNP.ARTIST(artist));
            ++n2;
        }
        return this;
    }

    public String getFirstGenre() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.GENRE.class);
    }

    public String[] getGenres() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.GENRE.class);
        return list.toArray(new String[list.size()]);
    }

    public PlaylistItem setGenres(String[] genres) {
        this.removeProperties(DIDLObject.Property.UPNP.GENRE.class);
        String[] stringArray = genres;
        int n = genres.length;
        int n2 = 0;
        while (n2 < n) {
            String genre = stringArray[n2];
            this.addProperty(new DIDLObject.Property.UPNP.GENRE(genre));
            ++n2;
        }
        return this;
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public PlaylistItem setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public PlaylistItem setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public String getLanguage() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.LANGUAGE.class);
    }

    public PlaylistItem setLanguage(String language) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.LANGUAGE(language));
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public PlaylistItem setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public PlaylistItem setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }
}

