/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.mock;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jupnp.DefaultUpnpServiceConfiguration;
import org.jupnp.transport.impl.NetworkAddressFactoryImpl;
import org.jupnp.transport.spi.NetworkAddressFactory;

public class MockUpnpServiceConfiguration
extends DefaultUpnpServiceConfiguration {
    protected final boolean maintainsRegistry;
    protected final boolean multiThreaded;

    public MockUpnpServiceConfiguration() {
        this(false, false);
    }

    public MockUpnpServiceConfiguration(boolean maintainsRegistry) {
        this(maintainsRegistry, false);
    }

    public MockUpnpServiceConfiguration(boolean maintainsRegistry, boolean multiThreaded) {
        super(false);
        this.maintainsRegistry = maintainsRegistry;
        this.multiThreaded = multiThreaded;
    }

    public boolean isMaintainsRegistry() {
        return this.maintainsRegistry;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    @Override
    protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort, int multicastResponsePort) {
        return new NetworkAddressFactoryImpl(streamListenPort, multicastResponsePort){

            @Override
            protected boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
                return iface.isLoopback();
            }

            @Override
            protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
                return address.isLoopbackAddress() && address instanceof Inet4Address;
            }
        };
    }

    @Override
    public Executor getRegistryMaintainerExecutor() {
        if (this.isMaintainsRegistry()) {
            return new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    new Thread(runnable).start();
                }
            };
        }
        return this.getDefaultExecutorService();
    }

    @Override
    protected ExecutorService getDefaultExecutorService() {
        if (this.isMultiThreaded()) {
            return super.getDefaultExecutorService();
        }
        return new AbstractExecutorService(){
            boolean terminated;

            @Override
            public void shutdown() {
                this.terminated = true;
            }

            @Override
            public List<Runnable> shutdownNow() {
                this.shutdown();
                return null;
            }

            @Override
            public boolean isShutdown() {
                return this.terminated;
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
                this.shutdown();
                return this.terminated;
            }

            @Override
            public void execute(Runnable runnable) {
                runnable.run();
            }
        };
    }
}

