/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jupnp.internal.compat.java.beans.PropertyChangeEvent;
import org.jupnp.internal.compat.java.beans.PropertyChangeListener;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.Command;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.util.Exceptions;
import org.jupnp.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceManager<T>
implements ServiceManager<T> {
    private Logger log = LoggerFactory.getLogger(DefaultServiceManager.class);
    protected final LocalService<T> service;
    protected final Class<T> serviceClass;
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected T serviceImpl;
    protected PropertyChangeSupport propertyChangeSupport;

    protected DefaultServiceManager(LocalService<T> service) {
        this(service, null);
    }

    public DefaultServiceManager(LocalService<T> service, Class<T> serviceClass) {
        this.service = service;
        this.serviceClass = serviceClass;
    }

    protected void lock() {
        try {
            if (!this.lock.tryLock(this.getLockTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Failed to acquire lock in milliseconds: " + this.getLockTimeoutMillis());
            }
            this.log.trace("Acquired lock");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to acquire lock:" + e);
        }
    }

    protected void unlock() {
        this.log.trace("Releasing lock");
        this.lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 500;
    }

    @Override
    public LocalService<T> getService() {
        return this.service;
    }

    @Override
    public T getImplementation() {
        this.lock();
        try {
            if (this.serviceImpl == null) {
                this.init();
            }
            T t = this.serviceImpl;
            return t;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        this.lock();
        try {
            if (this.propertyChangeSupport == null) {
                this.init();
            }
            PropertyChangeSupport propertyChangeSupport = this.propertyChangeSupport;
            return propertyChangeSupport;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void execute(Command<T> cmd) throws Exception {
        this.lock();
        try {
            cmd.execute(this);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Collection<StateVariableValue> getCurrentState() throws Exception {
        this.lock();
        try {
            Collection<StateVariableValue> values = this.readInitialEventedStateVariableValues();
            if (values != null) {
                this.log.trace("Obtained initial state variable values for event, skipping individual state variable accessors");
                Collection<StateVariableValue> collection = values;
                return collection;
            }
            values = new ArrayList<StateVariableValue>();
            StateVariable<S>[] stateVariableArray = this.getService().getStateVariables();
            int n = stateVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                StateVariable<LocalService> stateVariable = stateVariableArray[n2];
                if (stateVariable.getEventDetails().isSendEvents()) {
                    StateVariableAccessor accessor = this.getService().getAccessor(stateVariable);
                    if (accessor == null) {
                        throw new IllegalStateException("No accessor for evented state variable");
                    }
                    values.add(accessor.read(stateVariable, this.getImplementation()));
                }
                ++n2;
            }
            Collection<StateVariableValue> collection = values;
            return collection;
        }
        finally {
            this.unlock();
        }
    }

    protected Collection<StateVariableValue> getCurrentState(String[] variableNames) throws Exception {
        this.lock();
        try {
            ArrayList<StateVariableValue> values = new ArrayList<StateVariableValue>();
            String[] stringArray = variableNames;
            int n = variableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String variableName = stringArray[n2];
                variableName = variableName.trim();
                StateVariable<LocalService> stateVariable = this.getService().getStateVariable(variableName);
                if (stateVariable == null || !stateVariable.getEventDetails().isSendEvents()) {
                    this.log.trace("Ignoring unknown or non-evented state variable: " + variableName);
                } else {
                    StateVariableAccessor accessor = this.getService().getAccessor(stateVariable);
                    if (accessor == null) {
                        this.log.warn("Ignoring evented state variable without accessor: " + variableName);
                    } else {
                        values.add(accessor.read(stateVariable, this.getImplementation()));
                    }
                }
                ++n2;
            }
            ArrayList<StateVariableValue> arrayList = values;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    protected void init() {
        this.log.trace("No service implementation instance available, initializing...");
        try {
            this.serviceImpl = this.createServiceInstance();
            this.propertyChangeSupport = this.createPropertyChangeSupport(this.serviceImpl);
            this.propertyChangeSupport.addPropertyChangeListener(this.createPropertyChangeListener(this.serviceImpl));
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not initialize implementation: " + ex, ex);
        }
    }

    protected T createServiceInstance() throws Exception {
        if (this.serviceClass == null) {
            throw new IllegalStateException("Subclass has to provide service class or override createServiceInstance()");
        }
        try {
            return this.serviceClass.getConstructor(LocalService.class).newInstance(this.getService());
        }
        catch (NoSuchMethodException ex) {
            this.log.trace("Creating new service implementation instance with no-arg constructor: " + this.serviceClass.getName());
            return this.serviceClass.newInstance();
        }
    }

    protected PropertyChangeSupport createPropertyChangeSupport(T serviceImpl) throws Exception {
        Method m = Reflections.getGetterMethod(serviceImpl.getClass(), "propertyChangeSupport");
        if (m != null && PropertyChangeSupport.class.isAssignableFrom(m.getReturnType())) {
            this.log.trace("Service implementation instance offers PropertyChangeSupport, using that: " + serviceImpl.getClass().getName());
            return (PropertyChangeSupport)m.invoke(serviceImpl, new Object[0]);
        }
        this.log.trace("Creating new PropertyChangeSupport for service implementation: " + serviceImpl.getClass().getName());
        return new PropertyChangeSupport(serviceImpl);
    }

    protected PropertyChangeListener createPropertyChangeListener(T serviceImpl) throws Exception {
        return new DefaultPropertyChangeListener();
    }

    protected Collection<StateVariableValue> readInitialEventedStateVariableValues() throws Exception {
        return null;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Implementation: " + this.serviceImpl;
    }

    protected class DefaultPropertyChangeListener
    implements PropertyChangeListener {
        protected DefaultPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            DefaultServiceManager.this.log.trace("Property change event on local service: " + e.getPropertyName());
            if (e.getPropertyName().equals("_EventedStateVariables")) {
                return;
            }
            Object[] variableNames = ModelUtil.fromCommaSeparatedList(e.getPropertyName());
            DefaultServiceManager.this.log.trace("Changed variable names: " + Arrays.toString(variableNames));
            try {
                Collection<StateVariableValue> currentValues = DefaultServiceManager.this.getCurrentState((String[])variableNames);
                if (!currentValues.isEmpty()) {
                    DefaultServiceManager.this.getPropertyChangeSupport().firePropertyChange("_EventedStateVariables", null, currentValues);
                }
            }
            catch (Exception ex) {
                DefaultServiceManager.this.log.error("Error reading state of service after state variable update event: " + Exceptions.unwrap(ex), (Throwable)ex);
            }
        }
    }
}

