/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.QueryStateVariableAction;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;

public class RemoteService
extends Service<RemoteDevice, RemoteService> {
    private final URI descriptorURI;
    private final URI controlURI;
    private final URI eventSubscriptionURI;

    public RemoteService(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI) throws ValidationException {
        this(serviceType, serviceId, descriptorURI, controlURI, eventSubscriptionURI, null, null);
    }

    public RemoteService(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI, Action<RemoteService>[] actions, StateVariable<RemoteService>[] stateVariables) throws ValidationException {
        super(serviceType, serviceId, actions, stateVariables);
        this.descriptorURI = descriptorURI;
        this.controlURI = controlURI;
        this.eventSubscriptionURI = eventSubscriptionURI;
        List<ValidationError> errors = this.validateThis();
        if (errors.size() > 0) {
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", errors);
        }
    }

    @Override
    public Action getQueryStateVariableAction() {
        return new QueryStateVariableAction<RemoteService>(this);
    }

    public URI getDescriptorURI() {
        return this.descriptorURI;
    }

    public URI getControlURI() {
        return this.controlURI;
    }

    public URI getEventSubscriptionURI() {
        return this.eventSubscriptionURI;
    }

    public List<ValidationError> validateThis() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDescriptorURI() == null) {
            errors.add(new ValidationError(this.getClass(), "descriptorURI", "Descriptor location (SCPDURL) is required"));
        }
        if (this.getControlURI() == null) {
            errors.add(new ValidationError(this.getClass(), "controlURI", "Control URL is required"));
        }
        if (this.getEventSubscriptionURI() == null) {
            errors.add(new ValidationError(this.getClass(), "eventSubscriptionURI", "Event subscription URL is required"));
        }
        return errors;
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Descriptor: " + this.getDescriptorURI();
    }
}

