/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.StateVariableAllowedValueRange;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;

public class StateVariableTypeDetails
implements Validatable {
    private final Datatype datatype;
    private final String defaultValue;
    private final String[] allowedValues;
    private final StateVariableAllowedValueRange allowedValueRange;

    public StateVariableTypeDetails(Datatype datatype) {
        this(datatype, null, null, null);
    }

    public StateVariableTypeDetails(Datatype datatype, String defaultValue) {
        this(datatype, defaultValue, null, null);
    }

    public StateVariableTypeDetails(Datatype datatype, String defaultValue, String[] allowedValues, StateVariableAllowedValueRange allowedValueRange) {
        this.datatype = datatype;
        this.defaultValue = defaultValue;
        this.allowedValues = allowedValues;
        this.allowedValueRange = allowedValueRange;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getAllowedValues() {
        if (!this.foundDefaultInAllowedValues(this.defaultValue, this.allowedValues)) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.allowedValues));
            list.add(this.getDefaultValue());
            return list.toArray(new String[list.size()]);
        }
        return this.allowedValues;
    }

    public StateVariableAllowedValueRange getAllowedValueRange() {
        return this.allowedValueRange;
    }

    protected boolean foundDefaultInAllowedValues(String defaultValue, String[] allowedValues) {
        if (defaultValue == null || allowedValues == null) {
            return true;
        }
        String[] stringArray = allowedValues;
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(defaultValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDatatype() == null) {
            errors.add(new ValidationError(this.getClass(), "datatype", "Service state variable has no datatype"));
        }
        if (this.getAllowedValues() != null) {
            if (this.getAllowedValueRange() != null) {
                errors.add(new ValidationError(this.getClass(), "allowedValues", "Allowed value list of state variable can not also be restricted with allowed value range"));
            }
            if (!Datatype.Builtin.STRING.equals((Object)this.getDatatype().getBuiltin())) {
                errors.add(new ValidationError(this.getClass(), "allowedValues", "Allowed value list of state variable only available for string datatype, not: " + this.getDatatype()));
            }
            String[] stringArray = this.getAllowedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() > 31) {
                    SpecificationViolationReporter.report("Allowed value string must be less than 32 chars: {}", s);
                }
                ++n2;
            }
            if (!this.foundDefaultInAllowedValues(this.defaultValue, this.allowedValues)) {
                SpecificationViolationReporter.report("Allowed string values don't contain default value: {}", this.defaultValue);
            }
        }
        if (this.getAllowedValueRange() != null) {
            errors.addAll(this.getAllowedValueRange().validate());
        }
        return errors;
    }
}

