/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.InvalidValueException;

public class BytesRange {
    public static final String PREFIX = "bytes=";
    private Long firstByte;
    private Long lastByte;
    private Long byteLength;

    public BytesRange(Long firstByte, Long lastByte) {
        this.firstByte = firstByte;
        this.lastByte = lastByte;
        this.byteLength = null;
    }

    public BytesRange(Long firstByte, Long lastByte, Long byteLength) {
        this.firstByte = firstByte;
        this.lastByte = lastByte;
        this.byteLength = byteLength;
    }

    public Long getFirstByte() {
        return this.firstByte;
    }

    public Long getLastByte() {
        return this.lastByte;
    }

    public Long getByteLength() {
        return this.byteLength;
    }

    public String getString() {
        return this.getString(false, null);
    }

    public String getString(boolean includeDuration) {
        return this.getString(includeDuration, null);
    }

    public String getString(boolean includeDuration, String rangePrefix) {
        String s;
        String string = s = rangePrefix != null ? rangePrefix : PREFIX;
        if (this.firstByte != null) {
            s = String.valueOf(s) + this.firstByte.toString();
        }
        s = String.valueOf(s) + "-";
        if (this.lastByte != null) {
            s = String.valueOf(s) + this.lastByte.toString();
        }
        if (includeDuration) {
            s = String.valueOf(s) + "/" + (this.byteLength != null ? this.byteLength.toString() : "*");
        }
        return s;
    }

    public static BytesRange valueOf(String s) throws InvalidValueException {
        return BytesRange.valueOf(s, null);
    }

    public static BytesRange valueOf(String s, String rangePrefix) throws InvalidValueException {
        if (s.startsWith(rangePrefix != null ? rangePrefix : PREFIX)) {
            Long firstByte = null;
            Long lastByte = null;
            Long byteLength = null;
            String[] params = s.substring((rangePrefix != null ? rangePrefix : PREFIX).length()).split("[-/]");
            switch (params.length) {
                case 3: {
                    if (params[2].length() != 0 && !params[2].equals("*")) {
                        byteLength = Long.parseLong(params[2]);
                    }
                }
                case 2: {
                    if (params[1].length() != 0) {
                        lastByte = Long.parseLong(params[1]);
                    }
                }
                case 1: {
                    if (params[0].length() != 0) {
                        firstByte = Long.parseLong(params[0]);
                    }
                    if (firstByte == null && lastByte == null) break;
                    return new BytesRange(firstByte, lastByte, byteLength);
                }
            }
        }
        throw new InvalidValueException("Can't parse Bytes Range: " + s);
    }
}

