/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.net.URL;
import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeRequestMessage;
import org.jupnp.model.message.gena.OutgoingSubscribeResponseMessage;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.ServiceEventSubscriptionResource;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSubscribe
extends ReceivingSync<StreamRequestMessage, OutgoingSubscribeResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(ReceivingSubscribe.class);
    protected LocalGENASubscription subscription;

    public ReceivingSubscribe(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected OutgoingSubscribeResponseMessage executeSync() throws RouterException {
        ServiceEventSubscriptionResource resource = this.getUpnpService().getRegistry().getResource(ServiceEventSubscriptionResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri());
        if (resource == null) {
            this.log.trace("No local resource found: " + this.getInputMessage());
            return null;
        }
        this.log.trace("Found local event subscription matching relative request URI: " + ((StreamRequestMessage)this.getInputMessage()).getUri());
        IncomingSubscribeRequestMessage requestMessage = new IncomingSubscribeRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
        if (requestMessage.getSubscriptionId() != null && (requestMessage.hasNotificationHeader() || requestMessage.getCallbackURLs() != null)) {
            this.log.trace("Subscription ID and NT or Callback in subscribe request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.BAD_REQUEST);
        }
        if (requestMessage.getSubscriptionId() != null) {
            return this.processRenewal((LocalService)resource.getModel(), requestMessage);
        }
        if (requestMessage.hasNotificationHeader() && requestMessage.getCallbackURLs() != null) {
            return this.processNewSubscription((LocalService)resource.getModel(), requestMessage);
        }
        this.log.trace("No subscription ID, no NT or Callback, neither subscription or renewal: " + this.getInputMessage());
        return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
    }

    protected OutgoingSubscribeResponseMessage processRenewal(LocalService service, IncomingSubscribeRequestMessage requestMessage) {
        this.subscription = this.getUpnpService().getRegistry().getLocalSubscription(requestMessage.getSubscriptionId());
        if (this.subscription == null) {
            this.log.trace("Invalid subscription ID for renewal request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        this.log.trace("Renewing subscription: " + this.subscription);
        this.subscription.setSubscriptionDuration(requestMessage.getRequestedTimeoutSeconds());
        if (this.getUpnpService().getRegistry().updateLocalSubscription(this.subscription)) {
            return new OutgoingSubscribeResponseMessage(this.subscription);
        }
        this.log.trace("Subscription went away before it could be renewed: " + this.getInputMessage());
        return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
    }

    protected OutgoingSubscribeResponseMessage processNewSubscription(LocalService service, IncomingSubscribeRequestMessage requestMessage) {
        List<URL> callbackURLs = requestMessage.getCallbackURLs();
        if (callbackURLs == null || callbackURLs.size() == 0) {
            this.log.trace("Missing or invalid Callback URLs in subscribe request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        if (!requestMessage.hasNotificationHeader()) {
            this.log.trace("Missing or invalid NT header in subscribe request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        Integer timeoutSeconds = this.getUpnpService().getConfiguration().isReceivedSubscriptionTimeoutIgnored() ? null : requestMessage.getRequestedTimeoutSeconds();
        try {
            this.subscription = new LocalGENASubscription(service, timeoutSeconds, callbackURLs){

                @Override
                public void established() {
                }

                @Override
                public void ended(CancelReason reason) {
                }

                @Override
                public void eventReceived() {
                    ReceivingSubscribe.this.getUpnpService().getConfiguration().getSyncProtocolExecutorService().execute(ReceivingSubscribe.this.getUpnpService().getProtocolFactory().createSendingEvent(this));
                }
            };
        }
        catch (Exception ex) {
            this.log.warn("Couldn't create local subscription to service: " + Exceptions.unwrap(ex));
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
        this.log.trace("Adding subscription to registry: " + this.subscription);
        this.getUpnpService().getRegistry().addLocalSubscription(this.subscription);
        this.log.trace("Returning subscription response, waiting to send initial event");
        return new OutgoingSubscribeResponseMessage(this.subscription);
    }

    @Override
    public void responseSent(StreamResponseMessage responseMessage) {
        if (this.subscription == null) {
            return;
        }
        if (responseMessage != null && !((UpnpResponse)responseMessage.getOperation()).isFailed() && this.subscription.getCurrentSequence().getValue() == 0L) {
            this.log.trace("Establishing subscription");
            this.subscription.registerOnService();
            this.subscription.establish();
            this.log.trace("Response to subscription sent successfully, now sending initial event asynchronously");
            this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(this.getUpnpService().getProtocolFactory().createSendingEvent(this.subscription));
        } else if (this.subscription.getCurrentSequence().getValue() == 0L) {
            this.log.trace("Subscription request's response aborted, not sending initial event");
            if (responseMessage == null) {
                this.log.trace("Reason: No response at all from subscriber");
            } else {
                this.log.trace("Reason: " + responseMessage.getOperation());
            }
            this.log.trace("Removing subscription from registry: " + this.subscription);
            this.getUpnpService().getRegistry().removeLocalSubscription(this.subscription);
        }
    }

    @Override
    public void responseException(Throwable t) {
        if (this.subscription == null) {
            return;
        }
        this.log.trace("Response could not be send to subscriber, removing local GENA subscription: " + this.subscription);
        this.getUpnpService().getRegistry().removeLocalSubscription(this.subscription);
    }
}

