/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeResponseMessage;
import org.jupnp.model.message.gena.OutgoingRenewalRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingRenewal
extends SendingSync<OutgoingRenewalRequestMessage, IncomingSubscribeResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(SendingRenewal.class);
    protected final RemoteGENASubscription subscription;

    public SendingRenewal(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingRenewalRequestMessage(subscription, upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        StreamResponseMessage response;
        this.log.trace("Sending subscription renewal request: " + this.getInputMessage());
        try {
            response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
        }
        catch (RouterException ex) {
            this.onRenewalFailure();
            throw ex;
        }
        if (response == null) {
            this.onRenewalFailure();
            return null;
        }
        final IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
        if (((UpnpResponse)response.getOperation()).isFailed()) {
            this.log.trace("Subscription renewal failed, response was: " + response);
            this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation());
                }
            });
        } else if (!responseMessage.isValidHeaders()) {
            this.log.error("Subscription renewal failed, invalid or missing (SID, Timeout) response headers");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation());
                }
            });
        } else {
            this.log.trace("Subscription renewed, updating in registry, response was: " + response);
            this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
            this.getUpnpService().getRegistry().updateRemoteSubscription(this.subscription);
        }
        return responseMessage;
    }

    protected void onRenewalFailure() {
        this.log.trace("Subscription renewal failed, removing subscription from registry");
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, null);
            }
        });
    }
}

