/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport;

import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.transport.DisableRouter;
import org.jupnp.transport.EnableRouter;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.NoNetworkException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;
import org.jupnp.transport.spi.UpnpStream;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterImpl
implements Router {
    private Logger log = LoggerFactory.getLogger(Router.class);
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected volatile boolean enabled;
    protected ReentrantReadWriteLock routerLock = new ReentrantReadWriteLock(true);
    protected Lock readLock = this.routerLock.readLock();
    protected Lock writeLock = this.routerLock.writeLock();
    protected NetworkAddressFactory networkAddressFactory;
    protected StreamClient streamClient;
    protected final Map<NetworkInterface, MulticastReceiver> multicastReceivers = new HashMap<NetworkInterface, MulticastReceiver>();
    protected final Map<InetAddress, DatagramIO> datagramIOs = new HashMap<InetAddress, DatagramIO>();
    protected final Map<InetAddress, StreamServer> streamServers = new HashMap<InetAddress, StreamServer>();

    protected RouterImpl() {
    }

    public RouterImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) {
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
    }

    public boolean enable(EnableRouter event) throws RouterException {
        return this.enable();
    }

    public boolean disable(DisableRouter event) throws RouterException {
        return this.disable();
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean enable() throws RouterException {
        this.lock(this.writeLock);
        try {
            if (!this.enabled) {
                try {
                    this.log.debug("Starting networking services...");
                    this.networkAddressFactory = this.getConfiguration().createNetworkAddressFactory();
                    this.startInterfaceBasedTransports(this.networkAddressFactory.getNetworkInterfaces());
                    this.startAddressBasedTransports(this.networkAddressFactory.getBindAddresses());
                    if (!this.networkAddressFactory.hasUsableNetwork()) {
                        throw new NoNetworkException("No usable network interface and/or addresses available, check the log for errors.");
                    }
                    this.streamClient = this.getConfiguration().createStreamClient();
                    this.enabled = true;
                    return true;
                }
                catch (InitializationException ex) {
                    this.handleStartFailure(ex);
                }
            }
            return false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    @Override
    public boolean disable() throws RouterException {
        this.lock(this.writeLock);
        try {
            if (this.enabled) {
                this.log.debug("Disabling network services...");
                if (this.streamClient != null) {
                    this.log.debug("Stopping stream client connection management/pool");
                    this.streamClient.stop();
                    this.streamClient = null;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    this.log.debug("Stopping stream server on address: " + entry.getKey());
                    entry.getValue().stop();
                }
                this.streamServers.clear();
                for (Map.Entry<Object, Runnable> entry : this.multicastReceivers.entrySet()) {
                    this.log.debug("Stopping multicast receiver on interface: " + ((NetworkInterface)entry.getKey()).getDisplayName());
                    ((MulticastReceiver)entry.getValue()).stop();
                }
                this.multicastReceivers.clear();
                for (Map.Entry<Object, Runnable> entry : this.datagramIOs.entrySet()) {
                    this.log.debug("Stopping datagram I/O on address: " + entry.getKey());
                    ((DatagramIO)entry.getValue()).stop();
                }
                this.datagramIOs.clear();
                this.networkAddressFactory = null;
                this.enabled = false;
                return true;
            }
            return false;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    @Override
    public void shutdown() throws RouterException {
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void handleStartFailure(InitializationException ex) throws InitializationException {
        if (ex instanceof NoNetworkException) {
            this.log.info("Unable to initialize network router, no network found.");
        } else {
            this.log.error("Unable to initialize network router: " + ex);
            this.log.error("Cause: " + Exceptions.unwrap(ex));
        }
    }

    @Override
    public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled && this.streamServers.size() > 0) {
                StreamServer preferredServer;
                ArrayList<NetworkAddress> streamServerAddresses = new ArrayList<NetworkAddress>();
                if (preferredAddress != null && (preferredServer = this.streamServers.get(preferredAddress)) != null) {
                    streamServerAddresses.add(new NetworkAddress(preferredAddress, preferredServer.getPort(), this.networkAddressFactory.getHardwareAddress(preferredAddress)));
                    ArrayList<NetworkAddress> arrayList = streamServerAddresses;
                    return arrayList;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    byte[] hardwareAddress = this.networkAddressFactory.getHardwareAddress(entry.getKey());
                    streamServerAddresses.add(new NetworkAddress(entry.getKey(), entry.getValue().getPort(), hardwareAddress));
                }
                ArrayList<NetworkAddress> arrayList = streamServerAddresses;
                return arrayList;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public void received(IncomingDatagramMessage msg) {
        if (!this.enabled) {
            this.log.debug("Router disabled, ignoring incoming message: " + msg);
            return;
        }
        try {
            ReceivingAsync protocol = this.getProtocolFactory().createReceivingAsync(msg);
            if (protocol == null) {
                this.log.trace("No protocol, ignoring received message: " + msg);
                return;
            }
            this.log.debug("Received asynchronous message: " + msg);
            this.getConfiguration().getAsyncProtocolExecutor().execute(protocol);
        }
        catch (ProtocolCreationException ex) {
            this.log.warn("Handling received datagram failed - " + Exceptions.unwrap(ex).toString());
        }
    }

    @Override
    public void received(UpnpStream stream) {
        if (!this.enabled) {
            this.log.debug("Router disabled, ignoring incoming: " + stream);
            return;
        }
        this.log.debug("Received synchronous stream: " + stream);
        this.getConfiguration().getSyncProtocolExecutorService().execute(stream);
    }

    @Override
    public void send(OutgoingDatagramMessage msg) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                for (DatagramIO datagramIO : this.datagramIOs.values()) {
                    datagramIO.send(msg);
                }
            } else {
                this.log.debug("Router disabled, not sending datagram: " + msg);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                if (this.streamClient == null) {
                    this.log.debug("No StreamClient available, not sending: " + msg);
                    return null;
                }
                this.log.debug("Sending via TCP unicast stream: " + msg);
                try {
                    StreamResponseMessage streamResponseMessage = this.streamClient.sendRequest(msg);
                    return streamResponseMessage;
                }
                catch (InterruptedException ex) {
                    throw new RouterException("Sending stream request was interrupted", ex);
                }
            }
            this.log.debug("Router disabled, not sending stream request: " + msg);
            return null;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public void broadcast(byte[] bytes) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                for (Map.Entry<InetAddress, DatagramIO> entry : this.datagramIOs.entrySet()) {
                    InetAddress broadcast = this.networkAddressFactory.getBroadcastAddress(entry.getKey());
                    if (broadcast == null) continue;
                    this.log.debug("Sending UDP datagram to broadcast address: " + broadcast.getHostAddress());
                    DatagramPacket packet = new DatagramPacket(bytes, bytes.length, broadcast, 9);
                    entry.getValue().send(packet);
                }
            } else {
                this.log.debug("Router disabled, not broadcasting bytes: " + bytes.length);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    protected void startInterfaceBasedTransports(Iterator<NetworkInterface> interfaces) throws InitializationException {
        while (interfaces.hasNext()) {
            NetworkInterface networkInterface = interfaces.next();
            MulticastReceiver multicastReceiver = this.getConfiguration().createMulticastReceiver(this.networkAddressFactory);
            if (multicastReceiver == null) {
                this.log.info("Configuration did not create a MulticastReceiver for: " + networkInterface);
                continue;
            }
            this.log.debug("Init multicast receiver on interface: " + networkInterface.getDisplayName());
            multicastReceiver.init(networkInterface, this, this.networkAddressFactory, this.getConfiguration().getDatagramProcessor());
            this.multicastReceivers.put(networkInterface, multicastReceiver);
        }
        for (Map.Entry<NetworkInterface, MulticastReceiver> entry : this.multicastReceivers.entrySet()) {
            this.log.debug("Starting multicast receiver on interface: " + entry.getKey().getDisplayName());
            this.getConfiguration().getMulticastReceiverExecutor().execute(entry.getValue());
        }
    }

    protected void startAddressBasedTransports(Iterator<InetAddress> addresses) throws InitializationException {
        while (addresses.hasNext()) {
            InetAddress inetAddress = addresses.next();
            StreamServer streamServer = this.getConfiguration().createStreamServer(this.networkAddressFactory);
            if (streamServer == null) {
                this.log.info("Configuration did not create a StreamServer for: " + inetAddress);
            } else {
                try {
                    this.log.debug("Init stream server on address: " + inetAddress);
                    streamServer.init(inetAddress, this);
                    this.streamServers.put(inetAddress, streamServer);
                }
                catch (InitializationException ex) {
                    Throwable cause = Exceptions.unwrap(ex);
                    if (cause instanceof BindException) {
                        this.log.warn("Failed to init StreamServer: " + cause);
                        this.log.debug("Initialization exception root cause", cause);
                        this.log.warn("Removing unusable address: " + inetAddress);
                        addresses.remove();
                        continue;
                    }
                    throw ex;
                }
            }
            DatagramIO datagramIO = this.getConfiguration().createDatagramIO(this.networkAddressFactory);
            if (datagramIO == null) {
                this.log.info("Configuration did not create a StreamServer for: " + inetAddress);
                continue;
            }
            this.log.debug("Init datagram I/O on address: " + inetAddress);
            datagramIO.init(inetAddress, this.networkAddressFactory.getMulticastResponsePort(), this, this.getConfiguration().getDatagramProcessor());
            this.datagramIOs.put(inetAddress, datagramIO);
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
            this.log.debug("Starting stream server on address: " + entry.getKey());
            this.getConfiguration().getStreamServerExecutorService().execute(entry.getValue());
        }
        for (Map.Entry<InetAddress, Runnable> entry : this.datagramIOs.entrySet()) {
            this.log.debug("Starting datagram I/O on address: " + entry.getKey());
            this.getConfiguration().getDatagramIOExecutor().execute(entry.getValue());
        }
    }

    protected void lock(Lock lock, int timeoutMilliseconds) throws RouterException {
        try {
            this.log.trace("Trying to obtain lock with timeout milliseconds '" + timeoutMilliseconds + "': " + lock.getClass().getSimpleName());
            if (!lock.tryLock(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                throw new RouterException("Router wasn't available exclusively after waiting " + timeoutMilliseconds + "ms, lock failed: " + lock.getClass().getSimpleName());
            }
            this.log.trace("Acquired router lock: " + lock.getClass().getSimpleName());
        }
        catch (InterruptedException ex) {
            throw new RouterException("Interruption while waiting for exclusive access: " + lock.getClass().getSimpleName(), ex);
        }
    }

    protected void lock(Lock lock) throws RouterException {
        this.lock(lock, this.getLockTimeoutMillis());
    }

    protected void unlock(Lock lock) {
        this.log.trace("Releasing router lock: " + lock.getClass().getSimpleName());
        lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 6000;
    }
}

