/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramIOImpl
implements DatagramIO<DatagramIOConfigurationImpl> {
    private Logger log = LoggerFactory.getLogger(DatagramIOImpl.class);
    protected final DatagramIOConfigurationImpl configuration;
    protected Router router;
    protected DatagramProcessor datagramProcessor;
    protected InetSocketAddress localAddress;
    protected MulticastSocket socket;

    public DatagramIOImpl(DatagramIOConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public DatagramIOConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, int bindPort, Router router, DatagramProcessor datagramProcessor) throws InitializationException {
        this.router = router;
        this.datagramProcessor = datagramProcessor;
        try {
            this.log.debug("Creating bound socket (for datagram input/output) on: " + bindAddress + ":" + bindPort);
            this.localAddress = new InetSocketAddress(bindAddress, bindPort);
            this.socket = new MulticastSocket(this.localAddress);
            this.socket.setTimeToLive(this.configuration.getTimeToLive());
            this.socket.setReceiveBufferSize(262144);
        }
        catch (Exception ex) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName() + ": " + ex);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void run() {
        this.log.debug("Entering blocking receiving loop, listening for UDP datagrams on: " + this.socket.getLocalAddress() + ":" + this.socket.getPort());
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[this.getConfiguration().getMaxDatagramBytes()];
                    DatagramPacket datagram = new DatagramPacket(buf, buf.length);
                    this.socket.receive(datagram);
                    this.log.debug("UDP datagram received from: " + datagram.getAddress().getHostAddress() + ":" + datagram.getPort() + " on: " + this.localAddress);
                    this.router.received(this.datagramProcessor.read(this.localAddress.getAddress(), datagram));
                }
            }
            catch (SocketException ex) {
                this.log.debug("Socket closed");
            }
            catch (UnsupportedDataException ex) {
                this.log.info("Could not read datagram: " + ex.getMessage());
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            break;
        }
        try {
            if (!this.socket.isClosed()) {
                this.log.debug("Closing unicast socket");
                this.socket.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public synchronized void send(OutgoingDatagramMessage message) {
        this.log.debug("Sending message from address: " + this.localAddress);
        DatagramPacket packet = this.datagramProcessor.write(message);
        this.log.debug("Sending UDP datagram packet to: " + message.getDestinationAddress() + ":" + message.getDestinationPort());
        this.send(packet);
    }

    @Override
    public synchronized void send(DatagramPacket datagram) {
        this.log.debug("Sending message from address: " + this.localAddress);
        try {
            this.socket.send(datagram);
        }
        catch (SocketException ex) {
            this.log.debug("Socket closed, aborting datagram send to: " + datagram.getAddress());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.log.error("Exception sending datagram to: " + datagram.getAddress() + ": " + ex, (Throwable)ex);
            this.log.error("  Details: datagram.socketAddress={}, length={}, offfset={}, data.bytes={}", new Object[]{datagram.getSocketAddress(), datagram.getLength(), datagram.getOffset(), datagram.getData().length});
            try {
                this.log.error("  Details: socket={}, closed={}, bound={}, inetAddress={}, remoteSocketAddress={}, networkInterface=" + this.socket.toString(), new Object[]{this.socket.isClosed(), this.socket.isBound(), this.socket.getInetAddress(), this.socket.getRemoteSocketAddress(), this.socket.getNetworkInterface()});
            }
            catch (SocketException ex2) {
                this.log.error("  Details: could not get network interface due to {}", (Object)ex2, (Object)ex2);
            }
        }
    }
}

